/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.map;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactoryCodegenField;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetterAndIndexed;
import java.util.Map;

public class MapArrayPropertyGetter
implements MapEventPropertyGetter,
MapEventPropertyGetterAndIndexed {
    private final String propertyName;
    private final int index;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final EventType fragmentType;

    public MapArrayPropertyGetter(String propertyNameAtomic, int index, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventType fragmentType) {
        this.propertyName = propertyNameAtomic;
        this.index = index;
        this.fragmentType = fragmentType;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        return this.getMapInternal(map, this.index);
    }

    @Override
    public Object get(EventBean eventBean, int index) throws PropertyAccessException {
        Map<String, Object> map = BaseNestableEventUtil.checkedCastUnderlyingMap(eventBean);
        return this.getMapInternal(map, index);
    }

    @Override
    public Object get(EventBean obj) throws PropertyAccessException {
        Map<String, Object> map = BaseNestableEventUtil.checkedCastUnderlyingMap(obj);
        return this.getMap(map);
    }

    private Object getMapInternal(Map<String, Object> map, int index) throws PropertyAccessException {
        Object value = map.get(this.propertyName);
        return BaseNestableEventUtil.getBNArrayValueAtIndexWithNullCheck(value, index);
    }

    private CodegenMethod getMapInternalCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return codegenMethodScope.makeChild(Object.class, this.getClass(), (CodegenScope)codegenClassScope).addParam(Map.class, "map").addParam(Integer.TYPE, "index").getBlock().declareVar(Object.class, "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("map"), "get", CodegenExpressionBuilder.constant(this.propertyName))).methodReturn(CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNArrayValueAtIndexWithNullCheck", CodegenExpressionBuilder.ref("value"), CodegenExpressionBuilder.ref("index")));
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) throws PropertyAccessException {
        Object value = this.get(obj);
        return BaseNestableEventUtil.getBNFragmentNonPojo(value, this.fragmentType, this.eventBeanTypedEventFactory);
    }

    private CodegenMethod getFragmentCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        CodegenExpressionField factory = codegenClassScope.addOrGetFieldSharable(EventBeanTypedEventFactoryCodegenField.INSTANCE);
        CodegenExpressionField eventType = codegenClassScope.addFieldUnshared(true, EventType.class, EventTypeUtility.resolveTypeCodegen(this.fragmentType, EPStatementInitServices.REF));
        return codegenMethodScope.makeChild(Object.class, this.getClass(), (CodegenScope)codegenClassScope).addParam(Map.class, "map").getBlock().declareVar(Object.class, "value", this.underlyingGetCodegen(CodegenExpressionBuilder.ref("map"), codegenMethodScope, codegenClassScope)).methodReturn(CodegenExpressionBuilder.staticMethod(BaseNestableEventUtil.class, "getBNFragmentNonPojo", CodegenExpressionBuilder.ref("value"), eventType, factory));
    }

    @Override
    public CodegenExpression eventBeanGetCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingGetCodegen(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression eventBeanExistsCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression eventBeanFragmentCodegen(CodegenExpression beanExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return this.underlyingFragmentCodegen(CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), codegenMethodScope, codegenClassScope);
    }

    @Override
    public CodegenExpression underlyingGetCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getMapInternalCodegen(codegenMethodScope, codegenClassScope), underlyingExpression, CodegenExpressionBuilder.constant(this.index));
    }

    @Override
    public CodegenExpression underlyingExistsCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.constantTrue();
    }

    @Override
    public CodegenExpression underlyingFragmentCodegen(CodegenExpression underlyingExpression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
        return CodegenExpressionBuilder.localMethod(this.getFragmentCodegen(codegenMethodScope, codegenClassScope), underlyingExpression);
    }

    @Override
    public CodegenExpression eventBeanGetIndexedCodegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpression beanExpression, CodegenExpression key) {
        return CodegenExpressionBuilder.localMethod(this.getMapInternalCodegen(codegenMethodScope, codegenClassScope), CodegenExpressionBuilder.castUnderlying(Map.class, beanExpression), key);
    }
}

