/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.map;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethod;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.event.map.MapEventType;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class MapEventBeanCopyMethodWithArrayMap
implements EventBeanCopyMethod {
    private final MapEventType mapEventType;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final String[] mapPropertiesToCopy;
    private final String[] arrayPropertiesToCopy;

    public MapEventBeanCopyMethodWithArrayMap(MapEventType mapEventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, String[] mapPropertiesToCopy, String[] arrayPropertiesToCopy) {
        this.mapEventType = mapEventType;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.mapPropertiesToCopy = mapPropertiesToCopy;
        this.arrayPropertiesToCopy = arrayPropertiesToCopy;
    }

    @Override
    public EventBean copy(EventBean theEvent) {
        MappedEventBean mapped = (MappedEventBean)theEvent;
        Map<String, Object> props = mapped.getProperties();
        HashMap<String, Object> shallowCopy = new HashMap<String, Object>(props);
        for (String name : this.mapPropertiesToCopy) {
            Map innerMap = (Map)props.get(name);
            if (innerMap == null) continue;
            HashMap copy = new HashMap(innerMap);
            shallowCopy.put(name, copy);
        }
        for (String name : this.arrayPropertiesToCopy) {
            Object array = props.get(name);
            if (array == null || !array.getClass().isArray() || Array.getLength(array) == 0) continue;
            Object copied = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array));
            System.arraycopy(array, 0, copied, 0, Array.getLength(array));
            shallowCopy.put(name, copied);
        }
        return this.eventBeanTypedEventFactory.adapterForTypedMap(shallowCopy, this.mapEventType);
    }
}

