/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.path;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonVariantStream;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.util.EventUnderlyingType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.avro.AvroSchemaEventType;
import com.espertech.esper.common.internal.event.avro.EventTypeAvroHandler;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventTypeStemService;
import com.espertech.esper.common.internal.event.bean.introspect.BeanEventTypeStem;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.eventtypefactory.EventTypeFactory;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.json.core.JsonEventTypeDetail;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.path.EventTypeCollectedSerde;
import com.espertech.esper.common.internal.event.path.EventTypeCollector;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import com.espertech.esper.common.internal.event.variant.VariantSpec;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import com.espertech.esper.common.internal.event.xml.SchemaUtil;
import com.espertech.esper.common.internal.event.xml.SchemaXMLEventType;
import com.espertech.esper.common.internal.event.xml.XMLFragmentEventTypeFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventTypeCollectorImpl
implements EventTypeCollector {
    private final Map<String, EventType> moduleEventTypes;
    private final BeanEventTypeFactory beanEventTypeFactory;
    private final ByteArrayProvidingClassLoader classLoader;
    private final EventTypeFactory eventTypeFactory;
    private final BeanEventTypeStemService beanEventTypeStemService;
    private final EventTypeNameResolver eventTypeNameResolver;
    private final XMLFragmentEventTypeFactory xmlFragmentEventTypeFactory;
    private final EventTypeAvroHandler eventTypeAvroHandler;
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final List<EventTypeCollectedSerde> serdes = new ArrayList<EventTypeCollectedSerde>();

    public EventTypeCollectorImpl(Map<String, EventType> moduleEventTypes, BeanEventTypeFactory beanEventTypeFactory, ByteArrayProvidingClassLoader classLoader, EventTypeFactory eventTypeFactory, BeanEventTypeStemService beanEventTypeStemService, EventTypeNameResolver eventTypeNameResolver, XMLFragmentEventTypeFactory xmlFragmentEventTypeFactory, EventTypeAvroHandler eventTypeAvroHandler, EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        this.moduleEventTypes = moduleEventTypes;
        this.beanEventTypeFactory = beanEventTypeFactory;
        this.classLoader = classLoader;
        this.eventTypeFactory = eventTypeFactory;
        this.beanEventTypeStemService = beanEventTypeStemService;
        this.eventTypeNameResolver = eventTypeNameResolver;
        this.xmlFragmentEventTypeFactory = xmlFragmentEventTypeFactory;
        this.eventTypeAvroHandler = eventTypeAvroHandler;
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
    }

    @Override
    public void registerMap(EventTypeMetadata metadata, LinkedHashMap<String, Object> properties, String[] superTypes, String startTimestampPropertyName, String endTimestampPropertyName) {
        MapEventType eventType = this.eventTypeFactory.createMap(metadata, properties, superTypes, startTimestampPropertyName, endTimestampPropertyName, this.beanEventTypeFactory, this.eventTypeNameResolver);
        this.handleRegister(eventType);
    }

    @Override
    public void registerObjectArray(EventTypeMetadata metadata, LinkedHashMap<String, Object> properties, String[] superTypes, String startTimestampPropertyName, String endTimestampPropertyName) {
        ObjectArrayEventType eventType = this.eventTypeFactory.createObjectArray(metadata, properties, superTypes, startTimestampPropertyName, endTimestampPropertyName, this.beanEventTypeFactory, this.eventTypeNameResolver);
        this.handleRegister(eventType);
    }

    @Override
    public void registerWrapper(EventTypeMetadata metadata, EventType underlying, LinkedHashMap<String, Object> properties) {
        WrapperEventType eventType = this.eventTypeFactory.createWrapper(metadata, underlying, properties, this.beanEventTypeFactory, this.eventTypeNameResolver);
        this.handleRegister(eventType);
    }

    @Override
    public void registerBean(EventTypeMetadata metadata, Class clazz, String startTimestampName, String endTimestampName, EventType[] superTypes, Set<EventType> deepSuperTypes) {
        BeanEventTypeStem stem = this.beanEventTypeStemService.getCreateStem(clazz, null);
        BeanEventType eventType = this.eventTypeFactory.createBeanType(stem, metadata, this.beanEventTypeFactory, superTypes, deepSuperTypes, startTimestampName, endTimestampName);
        this.handleRegister(eventType);
    }

    @Override
    public void registerJson(EventTypeMetadata metadata, LinkedHashMap<String, Object> properties, String[] superTypes, String startTimestampPropertyName, String endTimestampPropertyName, JsonEventTypeDetail detail) {
        JsonEventType eventType = this.eventTypeFactory.createJson(metadata, properties, superTypes, startTimestampPropertyName, endTimestampPropertyName, this.beanEventTypeFactory, this.eventTypeNameResolver, detail);
        eventType.initialize(this.classLoader);
        this.handleRegister(eventType);
    }

    @Override
    public void registerXML(EventTypeMetadata metadata, String representsFragmentOfProperty, String representsOriginalTypeName) {
        EventType existing = this.xmlFragmentEventTypeFactory.getTypeByName(metadata.getName());
        if (existing != null) {
            this.handleRegister(existing);
            return;
        }
        SchemaXMLEventType schemaType = this.xmlFragmentEventTypeFactory.getRootTypeByName(representsOriginalTypeName);
        if (schemaType == null) {
            throw new EPException("Failed to find XML schema type '" + representsOriginalTypeName + "'");
        }
        Property prop = PropertyParser.parseAndWalkLaxToSimple(representsFragmentOfProperty);
        SchemaElementComplex schemaModelRoot = SchemaUtil.findRootElement(schemaType.getSchemaModel(), schemaType.getConfigurationEventTypeXMLDOM().getRootElementNamespace(), schemaType.getRootElementName());
        SchemaItem item = prop.getPropertyTypeSchema(schemaModelRoot);
        SchemaElementComplex complex = (SchemaElementComplex)item;
        EventType eventType = this.xmlFragmentEventTypeFactory.getCreateXMLDOMType(representsOriginalTypeName, metadata.getName(), metadata.getModuleName(), complex, representsFragmentOfProperty);
        this.handleRegister(eventType);
    }

    @Override
    public void registerAvro(EventTypeMetadata metadata, String schemaJson, String[] superTypes) {
        Pair<EventType[], Set<EventType>> st = EventTypeUtility.getSuperTypesDepthFirst(superTypes, EventUnderlyingType.AVRO, this.eventTypeNameResolver);
        AvroSchemaEventType eventType = this.eventTypeAvroHandler.newEventTypeFromJson(metadata, this.eventBeanTypedEventFactory, schemaJson, st.getFirst(), st.getSecond());
        this.handleRegister(eventType);
    }

    @Override
    public void registerVariant(EventTypeMetadata metadata, EventType[] variants, boolean any) {
        VariantSpec spec = new VariantSpec(variants, any ? ConfigurationCommonVariantStream.TypeVariance.ANY : ConfigurationCommonVariantStream.TypeVariance.PREDEFINED);
        VariantEventType eventType = this.eventTypeFactory.createVariant(metadata, spec);
        this.handleRegister(eventType);
    }

    private void handleRegister(EventType eventType) {
        if (this.moduleEventTypes.containsKey(eventType.getName())) {
            throw new IllegalStateException("Event type '" + eventType.getName() + "' attempting to register multiple times");
        }
        this.moduleEventTypes.put(eventType.getName(), eventType);
    }

    @Override
    public void registerSerde(EventTypeMetadata metadata, DataInputOutputSerde<Object> underlyingSerde, Class underlyingClass) {
        this.serdes.add(new EventTypeCollectedSerde(metadata, underlyingSerde, underlyingClass));
    }

    public List<EventTypeCollectedSerde> getSerdes() {
        return this.serdes;
    }
}

