/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.property;

import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetterAndMapped;
import com.espertech.esper.common.internal.event.arr.ObjectArrayMappedPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.getter.KeyedMapFieldPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.KeyedMapMethodPropertyGetter;
import com.espertech.esper.common.internal.event.bean.getter.KeyedMethodPropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterAndMapped;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetterAndMapped;
import com.espertech.esper.common.internal.event.map.MapMappedPropertyGetter;
import com.espertech.esper.common.internal.event.property.GenericPropertyDesc;
import com.espertech.esper.common.internal.event.property.PropertyBase;
import com.espertech.esper.common.internal.event.property.PropertyWithKey;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.DOMMapGetter;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import com.espertech.esper.common.internal.event.xml.SchemaItemAttribute;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;

public class MappedProperty
extends PropertyBase
implements PropertyWithKey {
    private String key;

    public MappedProperty(String propertyName) {
        super(propertyName);
    }

    public MappedProperty(String propertyName, String key) {
        super(propertyName);
        this.key = key;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String[] toPropertyArray() {
        return new String[]{this.getPropertyNameAtomic()};
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public EventPropertyGetterAndMapped getGetter(BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem propertyDesc = eventType.getMappedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            Method method = propertyDesc.getReadMethod();
            return new KeyedMethodPropertyGetter(method, this.key, eventBeanTypedEventFactory, beanEventTypeFactory);
        }
        propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        Class returnType = propertyDesc.getReturnType();
        if (!JavaClassHelper.isImplementsInterface(returnType, Map.class)) {
            return null;
        }
        if (propertyDesc.getReadMethod() != null) {
            Method method = propertyDesc.getReadMethod();
            return new KeyedMapMethodPropertyGetter(method, this.key, eventBeanTypedEventFactory, beanEventTypeFactory);
        }
        Field field = propertyDesc.getAccessorField();
        return new KeyedMapFieldPropertyGetter(field, this.key, eventBeanTypedEventFactory, beanEventTypeFactory);
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem propertyDesc = eventType.getMappedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            return propertyDesc.getReadMethod().getReturnType();
        }
        PropertyStem descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (!JavaClassHelper.isImplementsInterface(returnType, Map.class)) {
            return null;
        }
        if (descriptor.getReadMethod() != null) {
            return JavaClassHelper.getGenericReturnTypeMap(descriptor.getReadMethod(), false);
        }
        if (descriptor.getAccessorField() != null) {
            return JavaClassHelper.getGenericFieldTypeMap(descriptor.getAccessorField(), false);
        }
        return null;
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem propertyDesc = eventType.getMappedProperty(this.propertyNameAtomic);
        if (propertyDesc != null) {
            return new GenericPropertyDesc(propertyDesc.getReadMethod().getReturnType());
        }
        PropertyStem descriptor = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (descriptor == null) {
            return null;
        }
        Class returnType = descriptor.getReturnType();
        if (!JavaClassHelper.isImplementsInterface(returnType, Map.class)) {
            return null;
        }
        if (descriptor.getReadMethod() != null) {
            Class genericType = JavaClassHelper.getGenericReturnTypeMap(descriptor.getReadMethod(), false);
            return new GenericPropertyDesc(genericType);
        }
        if (descriptor.getAccessorField() != null) {
            Class genericType = JavaClassHelper.getGenericFieldTypeMap(descriptor.getAccessorField(), false);
            return new GenericPropertyDesc(genericType);
        }
        return null;
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, BeanEventTypeFactory beanEventTypeFactory) {
        Object type = optionalMapPropTypes.get(this.getPropertyNameAtomic());
        if (type == null) {
            return null;
        }
        if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
            return Object.class;
        }
        return null;
    }

    @Override
    public MapEventPropertyGetterAndMapped getGetterMap(Map optionalMapPropTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        Object type = optionalMapPropTypes.get(this.getPropertyNameAtomic());
        if (type == null) {
            return null;
        }
        if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
            return new MapMappedPropertyGetter(this.getPropertyNameAtomic(), this.getKey());
        }
        if (type instanceof Map) {
            return new MapMappedPropertyGetter(this.getPropertyNameAtomic(), this.getKey());
        }
        return null;
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        writer.append(this.propertyNameAtomic);
        writer.append("('");
        writer.append(this.key);
        writer.append("')");
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM(SchemaElementComplex complexProperty, EventBeanTypedEventFactory eventBeanTypedEventFactory, BaseXMLEventType eventType, String propertyExpression) {
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.getName().equals(this.propertyNameAtomic)) continue;
            for (SchemaItemAttribute attribute : complex.getAttributes()) {
                if (attribute.getName().toLowerCase(Locale.ENGLISH).equals("id")) continue;
            }
            return new DOMMapGetter(this.propertyNameAtomic, this.key, null);
        }
        return null;
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM() {
        return new DOMMapGetter(this.propertyNameAtomic, this.key, null);
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex complexProperty) {
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            if (!complex.getName().equals(this.propertyNameAtomic)) continue;
            for (SchemaItemAttribute attribute : complex.getAttributes()) {
                if (attribute.getName().toLowerCase(Locale.ENGLISH).equals("id")) continue;
            }
            return complex;
        }
        return null;
    }

    @Override
    public ObjectArrayEventPropertyGetterAndMapped getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        Integer index = indexPerProperty.get(this.propertyNameAtomic);
        if (index == null) {
            return null;
        }
        Object type = nestableTypes.get(this.getPropertyNameAtomic());
        if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
            return new ObjectArrayMappedPropertyGetter(index, this.getKey());
        }
        if (type instanceof Map) {
            return new ObjectArrayMappedPropertyGetter(index, this.getKey());
        }
        return null;
    }
}

