/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.property;

import com.espertech.esper.common.client.EventPropertyGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.getter.NestedPropertyGetter;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapNestedPropertyGetterMapOnly;
import com.espertech.esper.common.internal.event.map.MapNestedPropertyGetterMixedType;
import com.espertech.esper.common.internal.event.property.DynamicProperty;
import com.espertech.esper.common.internal.event.property.DynamicSimpleProperty;
import com.espertech.esper.common.internal.event.property.GenericPropertyDesc;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyBase;
import com.espertech.esper.common.internal.event.property.SimpleProperty;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.DOMNestedPropertyGetter;
import com.espertech.esper.common.internal.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaElementSimple;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import com.espertech.esper.common.internal.event.xml.SchemaItemAttribute;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NestedProperty
implements Property {
    private List<Property> properties;

    public NestedProperty(List<Property> properties) {
        this.properties = properties;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    public boolean isDynamic() {
        for (Property property : this.properties) {
            if (!property.isDynamic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public EventPropertyGetterSPI getGetter(BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        Property lastProperty = null;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property;
            lastProperty = property = it.next();
            EventPropertyGetterSPI getter = property.getGetter(eventType, eventBeanTypedEventFactory, beanEventTypeFactory);
            if (getter == null) {
                return null;
            }
            if (it.hasNext()) {
                Class clazz = property.getPropertyType(eventType, beanEventTypeFactory);
                if (clazz == null) {
                    return null;
                }
                if (clazz == Map.class) {
                    return null;
                }
                if (clazz.isArray()) {
                    return null;
                }
                eventType = beanEventTypeFactory.getCreateBeanType(clazz);
            }
            getters.add(getter);
        }
        GenericPropertyDesc finalPropertyType = lastProperty.getPropertyTypeGeneric(eventType, beanEventTypeFactory);
        return new NestedPropertyGetter(getters, eventBeanTypedEventFactory, finalPropertyType.getType(), finalPropertyType.getGeneric(), beanEventTypeFactory);
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        Class result = null;
        boolean boxed = false;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            boxed |= !(property instanceof SimpleProperty);
            result = property.getPropertyType(eventType, beanEventTypeFactory);
            if (result == null) {
                return null;
            }
            if (!it.hasNext()) continue;
            if (result == Map.class) {
                return null;
            }
            if (result.isArray() || result.isPrimitive() || JavaClassHelper.isJavaBuiltinDataType(result)) {
                return null;
            }
            eventType = beanEventTypeFactory.getCreateBeanType(result);
        }
        return !boxed ? result : JavaClassHelper.getBoxedType(result);
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        GenericPropertyDesc result = null;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            result = property.getPropertyTypeGeneric(eventType, beanEventTypeFactory);
            if (result == null) {
                return null;
            }
            if (!it.hasNext()) continue;
            if (result.getType() == Map.class) {
                return null;
            }
            if (result.getType().isArray()) {
                return null;
            }
            eventType = beanEventTypeFactory.getCreateBeanType(result.getType());
        }
        return result;
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, BeanEventTypeFactory beanEventTypeFactory) {
        Map currentDictionary = optionalMapPropTypes;
        int count = 0;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            EventType innerType;
            ++count;
            Property property = it.next();
            PropertyBase theBase = (PropertyBase)property;
            String propertyName = theBase.getPropertyNameAtomic();
            Object nestedType = null;
            if (currentDictionary != null) {
                nestedType = currentDictionary.get(propertyName);
            }
            if (nestedType == null) {
                if (property instanceof DynamicProperty) {
                    return Object.class;
                }
                return null;
            }
            if (!it.hasNext()) {
                if (nestedType instanceof Class) {
                    return (Class)nestedType;
                }
                if (nestedType instanceof Map) {
                    return Map.class;
                }
            }
            if (nestedType == Map.class) {
                return Object.class;
            }
            if (nestedType instanceof Class) {
                Class pojoClass = (Class)nestedType;
                if (!pojoClass.isArray()) {
                    BeanEventType beanType = beanEventTypeFactory.getCreateBeanType(pojoClass);
                    String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                    return beanType.getPropertyType(remainingProps);
                }
                if (property instanceof IndexedProperty) {
                    Class<?> componentType = pojoClass.getComponentType();
                    BeanEventType beanType = beanEventTypeFactory.getCreateBeanType(componentType);
                    String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                    return beanType.getPropertyType(remainingProps);
                }
            }
            if (nestedType instanceof TypeBeanOrUnderlying) {
                innerType = ((TypeBeanOrUnderlying)nestedType).getEventType();
                if (innerType == null) {
                    return null;
                }
                String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                return innerType.getPropertyType(remainingProps);
            }
            if (nestedType instanceof TypeBeanOrUnderlying[]) {
                innerType = ((TypeBeanOrUnderlying[])nestedType)[0].getEventType();
                if (innerType == null) {
                    return null;
                }
                String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                return innerType.getPropertyType(remainingProps);
            }
            if (nestedType instanceof EventType) {
                innerType = (EventType)nestedType;
                String remainingProps = NestedProperty.toPropertyEPL(this.properties, count);
                return innerType.getPropertyType(remainingProps);
            }
            if (!(nestedType instanceof Map)) {
                String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + "' for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
                throw new PropertyAccessException(message);
            }
            currentDictionary = (Map)nestedType;
        }
        throw new IllegalStateException("Unexpected end of nested property");
    }

    @Override
    public MapEventPropertyGetter getGetterMap(Map optionalMapPropTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        LinkedList<EventPropertyGetterSPI> getters = new LinkedList<EventPropertyGetterSPI>();
        Map currentDictionary = optionalMapPropTypes;
        int count = 0;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            String remainingProps;
            EventPropertyGetterSPI getterInner;
            String remainingProps2;
            EventType innerType;
            ++count;
            Property property = it.next();
            MapEventPropertyGetter getter = property.getGetterMap(currentDictionary, eventBeanTypedEventFactory, beanEventTypeFactory);
            if (getter == null) {
                return null;
            }
            getters.add(getter);
            PropertyBase theBase = (PropertyBase)property;
            String propertyName = theBase.getPropertyNameAtomic();
            if (!it.hasNext() || currentDictionary == null) continue;
            Object propertyReturnType = currentDictionary.get(propertyName);
            if (propertyReturnType == null) {
                currentDictionary = null;
            }
            if (propertyReturnType == null) continue;
            if (propertyReturnType instanceof Map) {
                currentDictionary = (Map)propertyReturnType;
                continue;
            }
            if (propertyReturnType == Map.class) {
                currentDictionary = null;
                continue;
            }
            if (propertyReturnType instanceof TypeBeanOrUnderlying) {
                innerType = ((TypeBeanOrUnderlying)propertyReturnType).getEventType();
                if (innerType == null) {
                    return null;
                }
                remainingProps2 = NestedProperty.toPropertyEPL(this.properties, count);
                getterInner = ((EventTypeSPI)innerType).getGetterSPI(remainingProps2);
                if (getterInner == null) {
                    return null;
                }
                getters.add(getterInner);
                break;
            }
            if (propertyReturnType instanceof TypeBeanOrUnderlying[]) {
                innerType = ((TypeBeanOrUnderlying[])propertyReturnType)[0].getEventType();
                if (innerType == null) {
                    return null;
                }
                remainingProps2 = NestedProperty.toPropertyEPL(this.properties, count);
                getterInner = ((EventTypeSPI)innerType).getGetterSPI(remainingProps2);
                if (getterInner == null) {
                    return null;
                }
                getters.add(getterInner);
                break;
            }
            if (propertyReturnType instanceof EventType) {
                innerType = (EventType)propertyReturnType;
                remainingProps2 = NestedProperty.toPropertyEPL(this.properties, count);
                getterInner = ((EventTypeSPI)innerType).getGetterSPI(remainingProps2);
                if (getterInner == null) {
                    return null;
                }
                getters.add(getterInner);
                break;
            }
            Class pojoClass = (Class)propertyReturnType;
            if (!pojoClass.isArray()) {
                String remainingProps3;
                BeanEventType beanType = beanEventTypeFactory.getCreateBeanType(pojoClass);
                EventPropertyGetterSPI getterInner2 = beanType.getGetterSPI(remainingProps3 = NestedProperty.toPropertyEPL(this.properties, count));
                if (getterInner2 == null) {
                    return null;
                }
                getters.add(getterInner2);
                break;
            }
            Class<?> componentType = pojoClass.getComponentType();
            BeanEventType beanType = beanEventTypeFactory.getCreateBeanType(componentType);
            EventPropertyGetterSPI getterInner3 = beanType.getGetterSPI(remainingProps = NestedProperty.toPropertyEPL(this.properties, count));
            if (getterInner3 == null) {
                return null;
            }
            getters.add(getterInner3);
            break;
        }
        boolean hasNonmapGetters = false;
        for (int i = 0; i < getters.size(); ++i) {
            if (getters.get(i) instanceof MapEventPropertyGetter) continue;
            hasNonmapGetters = true;
        }
        if (!hasNonmapGetters) {
            return new MapNestedPropertyGetterMapOnly(getters, eventBeanTypedEventFactory);
        }
        return new MapNestedPropertyGetterMixedType(getters);
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        String delimiter = "";
        for (Property property : this.properties) {
            writer.append(delimiter);
            property.toPropertyEPL(writer);
            delimiter = ".";
        }
    }

    @Override
    public String[] toPropertyArray() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        for (Property property : this.properties) {
            String[] nested = property.toPropertyArray();
            propertyNames.addAll(Arrays.asList(nested));
        }
        return propertyNames.toArray(new String[propertyNames.size()]);
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM() {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        for (Property property : this.properties) {
            EventPropertyGetterSPI getter = property.getGetterDOM();
            if (getter == null) {
                return null;
            }
            getters.add(getter);
        }
        return new DOMNestedPropertyGetter(getters, null);
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM(SchemaElementComplex parentComplexProperty, EventBeanTypedEventFactory eventBeanTypedEventFactory, BaseXMLEventType eventType, String propertyExpression) {
        LinkedList<EventPropertyGetter> getters = new LinkedList<EventPropertyGetter>();
        SchemaElementComplex complexElement = parentComplexProperty;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            EventPropertyGetterSPI getter = property.getGetterDOM(complexElement, eventBeanTypedEventFactory, eventType, propertyExpression);
            if (getter == null) {
                return null;
            }
            if (it.hasNext()) {
                SchemaItem childSchemaItem = property.getPropertyTypeSchema(complexElement);
                if (childSchemaItem == null) {
                    return null;
                }
                if (childSchemaItem instanceof SchemaItemAttribute || childSchemaItem instanceof SchemaElementSimple) {
                    return null;
                }
                complexElement = (SchemaElementComplex)childSchemaItem;
                if (complexElement.isArray() && (property instanceof SimpleProperty || property instanceof DynamicSimpleProperty)) {
                    return null;
                }
            }
            getters.add(getter);
        }
        return new DOMNestedPropertyGetter(getters, new FragmentFactoryDOMGetter(eventBeanTypedEventFactory, eventType, propertyExpression));
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex parentComplexProperty) {
        Property lastProperty = null;
        SchemaElementComplex complexElement = parentComplexProperty;
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property;
            lastProperty = property = it.next();
            if (!it.hasNext()) continue;
            SchemaItem childSchemaItem = property.getPropertyTypeSchema(complexElement);
            if (childSchemaItem == null) {
                return null;
            }
            if (childSchemaItem instanceof SchemaItemAttribute || childSchemaItem instanceof SchemaElementSimple) {
                return null;
            }
            complexElement = (SchemaElementComplex)childSchemaItem;
        }
        return lastProperty.getPropertyTypeSchema(complexElement);
    }

    @Override
    public ObjectArrayEventPropertyGetter getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        throw new UnsupportedOperationException("Object array nested property getter not implemented as not implicitly nestable");
    }

    @Override
    public String getPropertyNameAtomic() {
        throw new UnsupportedOperationException("Nested properties do not provide an atomic property name");
    }

    private static String toPropertyEPL(List<Property> property, int startFromIndex) {
        String delimiter = "";
        StringWriter writer = new StringWriter();
        for (int i = startFromIndex; i < property.size(); ++i) {
            writer.append(delimiter);
            property.get(i).toPropertyEPL(writer);
            delimiter = ".";
        }
        return writer.getBuffer().toString();
    }
}

