/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.property;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventPropertyGetter;
import com.espertech.esper.common.internal.event.arr.ObjectArrayPropertyGetterDefaultObjectArray;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.bean.core.PropertyStem;
import com.espertech.esper.common.internal.event.bean.service.BeanEventTypeFactory;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventPropertyType;
import com.espertech.esper.common.internal.event.core.TypeBeanOrUnderlying;
import com.espertech.esper.common.internal.event.map.MapEventBeanPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapEventPropertyGetter;
import com.espertech.esper.common.internal.event.map.MapPropertyGetterDefaultNoFragment;
import com.espertech.esper.common.internal.event.property.GenericPropertyDesc;
import com.espertech.esper.common.internal.event.property.PropertyBase;
import com.espertech.esper.common.internal.event.property.PropertySimple;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.DOMAttributeAndElementGetter;
import com.espertech.esper.common.internal.event.xml.DOMComplexElementGetter;
import com.espertech.esper.common.internal.event.xml.DOMSimpleAttributeGetter;
import com.espertech.esper.common.internal.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaElementSimple;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import com.espertech.esper.common.internal.event.xml.SchemaItemAttribute;
import com.espertech.esper.common.internal.event.xml.SchemaUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.StringWriter;
import java.util.Map;

public class SimpleProperty
extends PropertyBase
implements PropertySimple {
    public SimpleProperty(String propertyName) {
        super(propertyName);
    }

    @Override
    public String[] toPropertyArray() {
        return new String[]{this.getPropertyNameAtomic()};
    }

    @Override
    public EventPropertyGetterSPI getGetter(BeanEventType eventType, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        if (!propertyDesc.getPropertyType().equals((Object)EventPropertyType.SIMPLE)) {
            return null;
        }
        return eventType.getGetterSPI(this.propertyNameAtomic);
    }

    @Override
    public Class getPropertyType(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        return propertyDesc.getReturnType();
    }

    @Override
    public GenericPropertyDesc getPropertyTypeGeneric(BeanEventType eventType, BeanEventTypeFactory beanEventTypeFactory) {
        PropertyStem propertyDesc = eventType.getSimpleProperty(this.propertyNameAtomic);
        if (propertyDesc == null) {
            return null;
        }
        return propertyDesc.getReturnTypeGeneric();
    }

    @Override
    public Class getPropertyTypeMap(Map optionalMapPropTypes, BeanEventTypeFactory beanEventTypeFactory) {
        if (optionalMapPropTypes == null) {
            return null;
        }
        Object def = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (def == null) {
            return null;
        }
        if (def instanceof Class) {
            return (Class)def;
        }
        if (def instanceof Map) {
            return Map.class;
        }
        if (def instanceof TypeBeanOrUnderlying) {
            EventType eventType = ((TypeBeanOrUnderlying)def).getEventType();
            return eventType.getUnderlyingType();
        }
        if (def instanceof TypeBeanOrUnderlying[]) {
            EventType eventType = ((TypeBeanOrUnderlying[])def)[0].getEventType();
            return JavaClassHelper.getArrayType(eventType.getUnderlyingType());
        }
        if (def instanceof EventType) {
            EventType eventType = (EventType)def;
            return eventType.getUnderlyingType();
        }
        if (def instanceof EventType[]) {
            EventType[] eventType = (EventType[])def;
            return JavaClassHelper.getArrayType(eventType[0].getUnderlyingType());
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + def.getClass() + "' for property '" + this.propertyNameAtomic + "', expected Map or Class";
        throw new PropertyAccessException(message);
    }

    @Override
    public MapEventPropertyGetter getGetterMap(Map optionalMapPropTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        if (optionalMapPropTypes == null) {
            return null;
        }
        Object def = optionalMapPropTypes.get(this.propertyNameAtomic);
        if (def == null) {
            return null;
        }
        if (def instanceof EventType) {
            return new MapEventBeanPropertyGetter(this.propertyNameAtomic, ((EventType)def).getUnderlyingType());
        }
        return new MapPropertyGetterDefaultNoFragment(this.propertyNameAtomic, eventBeanTypedEventFactory);
    }

    @Override
    public void toPropertyEPL(StringWriter writer) {
        writer.append(this.propertyNameAtomic);
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM() {
        return new DOMAttributeAndElementGetter(this.propertyNameAtomic);
    }

    @Override
    public EventPropertyGetterSPI getGetterDOM(SchemaElementComplex complexProperty, EventBeanTypedEventFactory eventBeanTypedEventFactory, BaseXMLEventType xmlEventType, String propertyExpression) {
        for (SchemaItemAttribute attribute : complexProperty.getAttributes()) {
            if (!attribute.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMSimpleAttributeGetter(this.propertyNameAtomic);
        }
        for (SchemaElementSimple simple : complexProperty.getSimpleElements()) {
            if (!simple.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMComplexElementGetter(this.propertyNameAtomic, null, simple.isArray());
        }
        for (SchemaElementComplex complex : complexProperty.getChildren()) {
            FragmentFactoryDOMGetter complexFragmentFactory = new FragmentFactoryDOMGetter(eventBeanTypedEventFactory, xmlEventType, propertyExpression);
            if (!complex.getName().equals(this.propertyNameAtomic)) continue;
            return new DOMComplexElementGetter(this.propertyNameAtomic, complexFragmentFactory, complex.isArray());
        }
        return null;
    }

    @Override
    public SchemaItem getPropertyTypeSchema(SchemaElementComplex complexProperty) {
        return SchemaUtil.findPropertyMapping(complexProperty, this.propertyNameAtomic);
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public ObjectArrayEventPropertyGetter getGetterObjectArray(Map<String, Integer> indexPerProperty, Map<String, Object> nestableTypes, EventBeanTypedEventFactory eventBeanTypedEventFactory, BeanEventTypeFactory beanEventTypeFactory) {
        if (nestableTypes == null) {
            return null;
        }
        Integer propertyIndex = indexPerProperty.get(this.propertyNameAtomic);
        if (propertyIndex == null) {
            return null;
        }
        return new ObjectArrayPropertyGetterDefaultObjectArray(propertyIndex, null, eventBeanTypedEventFactory);
    }
}

