/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.propertyparser;

import com.espertech.esper.common.client.PropertyAccessException;
import com.espertech.esper.common.internal.event.property.MappedPropertyParseResult;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.propertyparser.PropertyParseNodepException;
import com.espertech.esper.common.internal.event.propertyparser.PropertyTokenParser;
import com.espertech.esper.common.internal.event.propertyparser.Token;
import com.espertech.esper.common.internal.event.propertyparser.TokenType;
import com.espertech.esper.common.internal.event.propertyparser.Tokenizer;
import java.util.ArrayDeque;

public class PropertyParserNoDep {
    private static Tokenizer tokenizer = new Tokenizer();

    public static Property parseAndWalkLaxToSimple(String expression, boolean rootedDynamic) throws PropertyAccessException {
        try {
            ArrayDeque<Token> tokens = tokenizer.tokenize(expression);
            PropertyTokenParser parser = new PropertyTokenParser(tokens, rootedDynamic);
            return parser.property();
        }
        catch (PropertyParseNodepException ex) {
            throw new PropertyAccessException("Failed to parse property '" + expression + "': " + ex.getMessage(), ex);
        }
    }

    public static MappedPropertyParseResult parseMappedProperty(String property) {
        int endArg;
        int indexFirstDoubleQuote = property.indexOf("\"");
        int indexFirstSingleQuote = property.indexOf("'");
        if (indexFirstSingleQuote == -1 && indexFirstDoubleQuote == -1) {
            return null;
        }
        int startArg = indexFirstSingleQuote != -1 && indexFirstDoubleQuote != -1 ? (indexFirstSingleQuote < indexFirstDoubleQuote ? indexFirstSingleQuote : indexFirstDoubleQuote) : (indexFirstSingleQuote != -1 ? indexFirstSingleQuote : indexFirstDoubleQuote);
        int indexLastDoubleQuote = property.lastIndexOf("\"");
        int indexLastSingleQuote = property.lastIndexOf("'");
        if (indexLastSingleQuote == -1 && indexLastDoubleQuote == -1) {
            return null;
        }
        if (indexLastSingleQuote != -1 && indexLastDoubleQuote != -1) {
            endArg = indexLastSingleQuote > indexLastDoubleQuote ? indexLastSingleQuote : indexLastDoubleQuote;
        } else if (indexLastSingleQuote != -1) {
            if (indexLastSingleQuote == indexFirstSingleQuote) {
                return null;
            }
            endArg = indexLastSingleQuote;
        } else {
            if (indexLastDoubleQuote == indexFirstDoubleQuote) {
                return null;
            }
            endArg = indexLastDoubleQuote;
        }
        String argument = property.substring(startArg + 1, endArg);
        String[] splitDots = property.split("[\\.]");
        if (splitDots.length == 0) {
            return null;
        }
        int indexMethod = -1;
        for (int i = 0; i < splitDots.length; ++i) {
            if (!splitDots[i].contains("(")) continue;
            indexMethod = i;
            break;
        }
        if (indexMethod == -1) {
            return null;
        }
        String method = splitDots[indexMethod];
        int indexParan = method.indexOf("(");
        if ((method = method.substring(0, indexParan)).length() == 0) {
            return null;
        }
        if (splitDots.length == 1) {
            return new MappedPropertyParseResult(null, method, argument);
        }
        StringBuilder clazz = new StringBuilder();
        for (int i = 0; i < indexMethod; ++i) {
            if (i > 0) {
                clazz.append('.');
            }
            clazz.append(splitDots[i]);
        }
        return new MappedPropertyParseResult(clazz.toString(), method, argument);
    }

    static {
        tokenizer.add("[a-zA-Z]([a-zA-Z0-9_]|\\\\.)*", TokenType.IDENT);
        tokenizer.add("`[^`]*`", TokenType.IDENTESCAPED);
        tokenizer.add("[0-9]+", TokenType.NUMBER);
        tokenizer.add("\\[", TokenType.LBRACK);
        tokenizer.add("\\]", TokenType.RBRACK);
        tokenizer.add("\\(", TokenType.LPAREN);
        tokenizer.add("\\)", TokenType.RPAREN);
        tokenizer.add("\"([^\\\\\"]|\\\\\\\\|\\\\\")*\"", TokenType.DOUBLEQUOTEDLITERAL);
        tokenizer.add("'([^\\']|\\\\\\\\|\\')*'", TokenType.SINGLEQUOTEDLITERAL);
        tokenizer.add("\\.", TokenType.DOT);
        tokenizer.add("\\?", TokenType.QUESTION);
    }
}

