/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommonEventTypeXMLDOM;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeNameResolver;
import com.espertech.esper.common.internal.event.core.ExplicitPropertyDescriptor;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.event.xml.DOMConvertingArrayGetter;
import com.espertech.esper.common.internal.event.xml.DOMConvertingGetter;
import com.espertech.esper.common.internal.event.xml.DOMPropertyGetter;
import com.espertech.esper.common.internal.event.xml.FragmentFactoryDOMGetter;
import com.espertech.esper.common.internal.event.xml.SchemaElementComplex;
import com.espertech.esper.common.internal.event.xml.SchemaElementSimple;
import com.espertech.esper.common.internal.event.xml.SchemaItem;
import com.espertech.esper.common.internal.event.xml.SchemaItemAttribute;
import com.espertech.esper.common.internal.event.xml.SchemaModel;
import com.espertech.esper.common.internal.event.xml.SchemaUtil;
import com.espertech.esper.common.internal.event.xml.SchemaXMLPropertyParser;
import com.espertech.esper.common.internal.event.xml.XMLFragmentEventTypeFactory;
import com.espertech.esper.common.internal.event.xml.XPathNamespaceContext;
import com.espertech.esper.common.internal.event.xml.XPathPropertyArrayItemGetter;
import com.espertech.esper.common.internal.util.StringValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaXMLEventType
extends BaseXMLEventType {
    private static final Logger log = LoggerFactory.getLogger(SchemaXMLEventType.class);
    private final SchemaModel schemaModel;
    private final SchemaElementComplex schemaModelRoot;
    private final String rootElementNamespace;
    private final Map<String, EventPropertyGetterSPI> propertyGetterCache = new HashMap<String, EventPropertyGetterSPI>();
    private final boolean isPropertyExpressionXPath;
    private final String representsFragmentOfProperty;
    private final String representsOriginalTypeName;

    public SchemaXMLEventType(EventTypeMetadata eventTypeMetadata, ConfigurationCommonEventTypeXMLDOM config, SchemaModel schemaModel, String representsFragmentOfProperty, String representsOriginalTypeName, EventBeanTypedEventFactory eventBeanTypedEventFactory, EventTypeNameResolver eventTypeResolver, XMLFragmentEventTypeFactory xmlEventTypeFactory) {
        super(eventTypeMetadata, config, eventBeanTypedEventFactory, eventTypeResolver, xmlEventTypeFactory);
        ExplicitPropertyDescriptor explicit;
        EventPropertyGetterSPI getter;
        Class returnType;
        String propertyName;
        this.schemaModel = schemaModel;
        this.rootElementNamespace = config.getRootElementNamespace();
        this.schemaModelRoot = SchemaUtil.findRootElement(schemaModel, this.rootElementNamespace, this.getRootElementName());
        this.isPropertyExpressionXPath = config.isXPathPropertyExpr();
        this.representsFragmentOfProperty = representsFragmentOfProperty;
        this.representsOriginalTypeName = representsOriginalTypeName;
        XPathNamespaceContext ctx = new XPathNamespaceContext();
        if (config.getDefaultNamespace() != null) {
            ctx.setDefaultNamespace(config.getDefaultNamespace());
        }
        for (Map.Entry<String, String> entry : config.getNamespacePrefixes().entrySet()) {
            ctx.addPrefix(entry.getKey(), entry.getValue());
        }
        super.setNamespaceContext(ctx);
        ArrayList<ExplicitPropertyDescriptor> additionalSchemaProps = new ArrayList<ExplicitPropertyDescriptor>();
        for (SchemaElementComplex complex : this.schemaModelRoot.getChildren()) {
            propertyName = complex.getName();
            returnType = Node.class;
            Class<Node> propertyComponentType = null;
            if (complex.getOptionalSimpleType() != null) {
                returnType = SchemaUtil.toReturnType(complex);
            }
            if (complex.isArray()) {
                returnType = Node[].class;
                propertyComponentType = Node.class;
            }
            boolean isFragment = false;
            if (this.getConfigurationEventTypeXMLDOM().isAutoFragment() && !this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr()) {
                isFragment = this.canFragment(complex);
            }
            EventPropertyGetterSPI getter2 = this.doResolvePropertyGetter(propertyName, true);
            EventPropertyDescriptor desc = new EventPropertyDescriptor(propertyName, returnType, propertyComponentType, false, false, complex.isArray(), false, isFragment);
            ExplicitPropertyDescriptor explicit2 = new ExplicitPropertyDescriptor(desc, getter2, false, null);
            additionalSchemaProps.add(explicit2);
        }
        for (SchemaElementSimple simple : this.schemaModelRoot.getSimpleElements()) {
            propertyName = simple.getName();
            returnType = SchemaUtil.toReturnType(simple);
            getter = this.doResolvePropertyGetter(propertyName, true);
            EventPropertyDescriptor desc = new EventPropertyDescriptor(propertyName, returnType, null, false, false, simple.isArray(), false, false);
            explicit = new ExplicitPropertyDescriptor(desc, getter, false, null);
            additionalSchemaProps.add(explicit);
        }
        for (SchemaItemAttribute attribute : this.schemaModelRoot.getAttributes()) {
            propertyName = attribute.getName();
            returnType = SchemaUtil.toReturnType(attribute);
            getter = this.doResolvePropertyGetter(propertyName, true);
            EventPropertyDescriptor desc = new EventPropertyDescriptor(propertyName, returnType, null, false, false, false, false, false);
            explicit = new ExplicitPropertyDescriptor(desc, getter, false, null);
            additionalSchemaProps.add(explicit);
        }
        super.initialize(config.getXPathProperties().values(), additionalSchemaProps);
    }

    public SchemaModel getSchemaModel() {
        return this.schemaModel;
    }

    @Override
    protected FragmentEventType doResolveFragmentType(String property) {
        EventType newType;
        if (!this.getConfigurationEventTypeXMLDOM().isAutoFragment() || this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr()) {
            return null;
        }
        Property prop = PropertyParser.parseAndWalkLaxToSimple(property);
        SchemaItem item = prop.getPropertyTypeSchema(this.schemaModelRoot);
        if (item == null || !this.canFragment(item)) {
            return null;
        }
        SchemaElementComplex complex = (SchemaElementComplex)item;
        String[] atomicProps = prop.toPropertyArray();
        String delimiterDot = ".";
        StringBuilder eventTypeNameBuilder = new StringBuilder(this.getName());
        for (String atomic : atomicProps) {
            eventTypeNameBuilder.append(delimiterDot);
            eventTypeNameBuilder.append(atomic);
        }
        String derivedEventTypeName = eventTypeNameBuilder.toString();
        EventType existingType = this.getXmlEventTypeFactory().getTypeByName(derivedEventTypeName);
        if (existingType != null) {
            return new FragmentEventType(existingType, complex.isArray(), false);
        }
        String represents = this.representsFragmentOfProperty == null ? property : this.representsFragmentOfProperty + "." + property;
        try {
            newType = this.getXmlEventTypeFactory().getCreateXMLDOMType(this.getRepresentsOriginalTypeName(), derivedEventTypeName, this.getMetadata().getModuleName(), complex, represents);
        }
        catch (Exception ex) {
            log.error("Failed to add dynamic event type for fragment of XML schema for property '" + property + "' :" + ex.getMessage(), (Throwable)ex);
            return null;
        }
        return new FragmentEventType(newType, complex.isArray(), false);
    }

    @Override
    protected Class doResolvePropertyType(String propertyExpression) {
        return this.doResolvePropertyType(propertyExpression, false);
    }

    private Class doResolvePropertyType(String propertyExpression, boolean allowSimpleProperties) {
        Property property;
        int index = StringValue.unescapedIndexOfDot(propertyExpression);
        if (!allowSimpleProperties && index == -1 && !(property = PropertyParser.parseAndWalkLaxToSimple(propertyExpression)).isDynamic()) {
            if (!(property instanceof IndexedProperty)) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            EventPropertyDescriptor descriptor = (EventPropertyDescriptor)this.propertyDescriptorMap.get(indexedProp.getPropertyNameAtomic());
            if (descriptor == null) {
                return null;
            }
            return descriptor.getPropertyType();
        }
        Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyExpression);
        if (prop.isDynamic()) {
            return Node.class;
        }
        SchemaItem item = prop.getPropertyTypeSchema(this.schemaModelRoot);
        if (item == null) {
            return null;
        }
        return SchemaUtil.toReturnType(item);
    }

    @Override
    protected EventPropertyGetterSPI doResolvePropertyGetter(String property) {
        return this.doResolvePropertyGetter(property, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EventPropertyGetterSPI doResolvePropertyGetter(String propertyExpression, boolean allowSimpleProperties) {
        Property property;
        int index;
        EventPropertyGetterSPI getter = this.propertyGetterCache.get(propertyExpression);
        if (getter != null) {
            return getter;
        }
        if (!allowSimpleProperties && (index = StringValue.unescapedIndexOfDot(propertyExpression)) == -1 && !(property = PropertyParser.parseAndWalkLaxToSimple(propertyExpression)).isDynamic()) {
            if (!(property instanceof IndexedProperty)) {
                return null;
            }
            IndexedProperty indexedProp = (IndexedProperty)property;
            getter = (EventPropertyGetterSPI)this.propertyGetters.get(indexedProp.getPropertyNameAtomic());
            if (null == getter) {
                return null;
            }
            EventPropertyDescriptor descriptor = (EventPropertyDescriptor)this.propertyDescriptorMap.get(indexedProp.getPropertyNameAtomic());
            if (descriptor == null) {
                return null;
            }
            if (!descriptor.isIndexed()) {
                return null;
            }
            if (descriptor.getPropertyType() == NodeList.class) {
                FragmentFactoryDOMGetter fragmentFactory = new FragmentFactoryDOMGetter(this.getEventBeanTypedEventFactory(), this, indexedProp.getPropertyNameAtomic());
                return new XPathPropertyArrayItemGetter(getter, indexedProp.getIndex(), fragmentFactory);
            }
        }
        if (!this.isPropertyExpressionXPath) {
            Property prop = PropertyParser.parseAndWalkLaxToSimple(propertyExpression);
            boolean isDynamic = prop.isDynamic();
            if (isDynamic) return prop.getGetterDOM();
            SchemaItem item = prop.getPropertyTypeSchema(this.schemaModelRoot);
            if (item == null) {
                return null;
            }
            getter = prop.getGetterDOM(this.schemaModelRoot, this.getEventBeanTypedEventFactory(), this, propertyExpression);
            if (getter == null) {
                return null;
            }
            Class returnType = SchemaUtil.toReturnType(item);
            if (returnType != Node.class && returnType != NodeList.class) {
                getter = !returnType.isArray() ? new DOMConvertingGetter((DOMPropertyGetter)getter, returnType) : new DOMConvertingArrayGetter((DOMPropertyGetter)getter, returnType.getComponentType());
            }
        } else {
            boolean allowFragments = !this.getConfigurationEventTypeXMLDOM().isXPathPropertyExpr();
            getter = SchemaXMLPropertyParser.getXPathResolution(propertyExpression, this.getXPathFactory(), this.getRootElementName(), this.rootElementNamespace, this.schemaModel, this.getEventBeanTypedEventFactory(), this, allowFragments, this.getConfigurationEventTypeXMLDOM().getDefaultNamespace());
        }
        this.propertyGetterCache.put(propertyExpression, getter);
        return getter;
    }

    public String getRepresentsFragmentOfProperty() {
        return this.representsFragmentOfProperty;
    }

    public String getRepresentsOriginalTypeName() {
        return this.representsOriginalTypeName;
    }

    private boolean canFragment(SchemaItem item) {
        if (!(item instanceof SchemaElementComplex)) {
            return false;
        }
        SchemaElementComplex complex = (SchemaElementComplex)item;
        return complex.getOptionalSimpleType() == null;
    }
}

