/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.event.xml;

import com.espertech.esper.common.internal.event.property.MappedProperty;
import com.espertech.esper.common.internal.event.property.NestedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyWithIndex;
import com.espertech.esper.common.internal.event.property.PropertyWithKey;

public class SimpleXMLPropertyParser {
    public static String walk(Property property, String rootElementName, String defaultNamespacePrefix, boolean isResolvePropertiesAbsolute) {
        StringBuilder xPathBuf = new StringBuilder();
        xPathBuf.append('/');
        if (isResolvePropertiesAbsolute) {
            if (defaultNamespacePrefix != null) {
                xPathBuf.append(defaultNamespacePrefix);
                xPathBuf.append(':');
            }
            xPathBuf.append(rootElementName);
        }
        if (!(property instanceof NestedProperty)) {
            xPathBuf.append(SimpleXMLPropertyParser.makeProperty(property, defaultNamespacePrefix));
        } else {
            NestedProperty nestedProperty = (NestedProperty)property;
            for (Property propertyNested : nestedProperty.getProperties()) {
                xPathBuf.append(SimpleXMLPropertyParser.makeProperty(propertyNested, defaultNamespacePrefix));
            }
        }
        return xPathBuf.toString();
    }

    private static String makeProperty(Property property, String defaultNamespacePrefix) {
        String prefix = "";
        if (defaultNamespacePrefix != null) {
            prefix = defaultNamespacePrefix + ":";
        }
        String unescapedIdent = property.getPropertyNameAtomic();
        if (property instanceof PropertyWithIndex) {
            int index = ((PropertyWithIndex)((Object)property)).getIndex();
            int xPathPosition = index + 1;
            return '/' + prefix + unescapedIdent + "[position() = " + xPathPosition + ']';
        }
        if (property instanceof MappedProperty) {
            String key = ((PropertyWithKey)((Object)property)).getKey();
            return '/' + prefix + unescapedIdent + "[@id='" + key + "']";
        }
        return '/' + prefix + unescapedIdent;
    }
}

