/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExprNodeAdapterBase {
    private static final Logger log = LoggerFactory.getLogger(ExprNodeAdapterBase.class);
    protected final FilterSpecParamExprNode factory;
    protected final ExprEvaluatorContext evaluatorContext;

    public abstract boolean evaluate(EventBean var1);

    public ExprNodeAdapterBase(FilterSpecParamExprNode factory, ExprEvaluatorContext evaluatorContext) {
        this.factory = factory;
        this.evaluatorContext = evaluatorContext;
    }

    protected final boolean evaluatePerStream(EventBean[] eventsPerStream) {
        try {
            Boolean result = (Boolean)this.factory.getExprNode().evaluate(eventsPerStream, true, this.evaluatorContext);
            if (result == null) {
                return false;
            }
            return result;
        }
        catch (RuntimeException ex) {
            String message = "Error evaluating expression '" + this.factory.getExprText() + "' statement '" + this.getStatementName() + "': " + ex.getMessage();
            log.error(message, (Throwable)ex);
            throw new EPException(message, ex);
        }
    }

    public String getStatementName() {
        return this.evaluatorContext.getStatementName();
    }

    public int getStatementId() {
        return this.evaluatorContext.getStatementId();
    }

    public int getFilterBoolExprNum() {
        return this.factory.getFilterBoolExprId();
    }

    public ExprEvaluatorContext getEvaluatorContext() {
        return this.evaluatorContext;
    }

    public int getStatementIdBoolExpr() {
        return this.factory.getStatementIdBooleanExpr();
    }

    public String getExpression() {
        return this.factory.getExprText();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExprNodeAdapterBase that = (ExprNodeAdapterBase)o;
        return this.evaluatorContext.getStatementId() == that.evaluatorContext.getStatementId() && this.evaluatorContext.getAgentInstanceId() == that.evaluatorContext.getAgentInstanceId() && this.factory.getFilterBoolExprId() == that.factory.getFilterBoolExprId();
    }

    public int hashCode() {
        int result = this.evaluatorContext.getStatementId();
        result = 31 * result + this.evaluatorContext.getAgentInstanceId();
        result = 31 * result + this.factory.getFilterBoolExprId();
        return result;
    }
}

