/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.filterspec;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.StatementContextFilterEvalEnv;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.filterspec.FilterAddendumUtil;
import com.espertech.esper.common.internal.filterspec.FilterSpecParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import com.espertech.esper.common.internal.filterspec.MatchedEventMap;
import com.espertech.esper.common.internal.filterspec.PropertyEvaluator;
import java.io.StringWriter;
import java.util.Arrays;

public final class FilterSpecActivatable {
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final FilterSpecParam[][] parameters;
    private final PropertyEvaluator optionalPropertyEvaluator;
    private final int filterCallbackId;

    public FilterSpecActivatable(EventType eventType, String eventTypeName, FilterSpecParam[][] filterParameters, PropertyEvaluator optionalPropertyEvaluator, int filterCallbackId) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.parameters = filterParameters;
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
        if (filterCallbackId == -1) {
            throw new IllegalArgumentException("Filter callback id is unassigned");
        }
        this.filterCallbackId = filterCallbackId;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final FilterSpecParam[][] getParameters() {
        return this.parameters;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluator getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public FilterValueSetParam[][] getValueSet(MatchedEventMap matchedEvents, FilterValueSetParam[][] addendum, ExprEvaluatorContext exprEvaluatorContext, StatementContextFilterEvalEnv filterEvalEnv) {
        FilterValueSetParam[][] valueList = FilterSpecActivatable.evaluateValueSet(this.parameters, matchedEvents, exprEvaluatorContext, filterEvalEnv);
        if (addendum != null) {
            valueList = FilterAddendumUtil.multiplyAddendum(addendum, valueList);
        }
        return valueList;
    }

    public static FilterValueSetParam[][] evaluateValueSet(FilterSpecParam[][] parameters, MatchedEventMap matchedEvents, AgentInstanceContext agentInstanceContext) {
        return FilterSpecActivatable.evaluateValueSet(parameters, matchedEvents, agentInstanceContext, agentInstanceContext.getStatementContextFilterEvalEnv());
    }

    public static FilterValueSetParam[][] evaluateValueSet(FilterSpecParam[][] parameters, MatchedEventMap matchedEvents, ExprEvaluatorContext exprEvaluatorContext, StatementContextFilterEvalEnv filterEvalEnv) {
        FilterValueSetParam[][] valueList = new FilterValueSetParam[parameters.length][];
        for (int i = 0; i < parameters.length; ++i) {
            valueList[i] = new FilterValueSetParam[parameters[i].length];
            FilterSpecActivatable.populateValueSet(valueList[i], matchedEvents, parameters[i], exprEvaluatorContext, filterEvalEnv);
        }
        return valueList;
    }

    private static void populateValueSet(FilterValueSetParam[] valueList, MatchedEventMap matchedEvents, FilterSpecParam[] specParams, ExprEvaluatorContext exprEvaluatorContext, StatementContextFilterEvalEnv filterEvalEnv) {
        int count = 0;
        for (FilterSpecParam specParam : specParams) {
            Object filterForValue = specParam.getFilterValue(matchedEvents, exprEvaluatorContext, filterEvalEnv);
            FilterValueSetParamImpl valueParam = new FilterValueSetParamImpl(specParam.getLookupable(), specParam.getFilterOperator(), filterForValue);
            valueList[count] = valueParam;
            ++count;
        }
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecActivatable type=" + this.filterForEventType);
        buffer.append(" parameters=" + Arrays.toString((Object[])this.parameters));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecActivatable)) {
            return false;
        }
        FilterSpecActivatable other = (FilterSpecActivatable)obj;
        if (!this.equalsTypeAndFilter(other)) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator == null) {
            return true;
        }
        if (this.optionalPropertyEvaluator != null && other.optionalPropertyEvaluator == null) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator != null) {
            return false;
        }
        return this.optionalPropertyEvaluator.compareTo(other.optionalPropertyEvaluator);
    }

    public boolean equalsTypeAndFilter(FilterSpecActivatable other) {
        if (this.filterForEventType != other.filterForEventType) {
            return false;
        }
        if (this.parameters.length != other.parameters.length) {
            return false;
        }
        for (int i = 0; i < this.parameters.length; ++i) {
            FilterSpecParam[] lineThis = this.parameters[i];
            FilterSpecParam[] lineOther = other.parameters[i];
            if (lineThis.length != lineOther.length) {
                return false;
            }
            for (int j = 0; j < lineThis.length; ++j) {
                if (lineThis[j].equals(lineOther[j])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        FilterSpecParam[][] filterSpecParamArray = this.parameters;
        int n = filterSpecParamArray.length;
        for (int i = 0; i < n; ++i) {
            FilterSpecParam[] paramLine;
            for (FilterSpecParam param : paramLine = filterSpecParamArray[i]) {
                hashCode ^= 31 * param.hashCode();
            }
        }
        return hashCode;
    }

    public int getFilterCallbackId() {
        return this.filterCallbackId;
    }

    public String getFilterText() {
        StringWriter writer = new StringWriter();
        writer.write(this.getFilterForEventType().getName());
        if (this.getParameters() != null && this.getParameters().length > 0) {
            writer.write(40);
            String delimiter = "";
            for (FilterSpecParam[] paramLine : this.getParameters()) {
                writer.write(delimiter);
                FilterSpecActivatable.writeFilter(writer, paramLine);
                delimiter = " or ";
            }
            writer.write(41);
        }
        return writer.toString();
    }

    private static void writeFilter(StringWriter writer, FilterSpecParam[] paramLine) {
        String delimiter = "";
        for (FilterSpecParam param : paramLine) {
            writer.write(delimiter);
            writer.write(param.getLookupable().getExpression());
            writer.write(param.getFilterOperator().getTextualOp());
            writer.write("...");
            delimiter = ",";
        }
    }
}

