/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.metrics.audit;

import com.espertech.esper.common.client.annotation.AuditEnum;

public class AuditContext {
    private final String runtimeURI;
    private final String deploymentId;
    private final String statementName;
    private final int agentInstanceId;
    private final AuditEnum category;
    private final String message;

    public AuditContext(String runtimeURI, String deploymentId, String statementName, int agentInstanceId, AuditEnum category, String message) {
        this.runtimeURI = runtimeURI;
        this.deploymentId = deploymentId;
        this.statementName = statementName;
        this.agentInstanceId = agentInstanceId;
        this.category = category;
        this.message = message;
    }

    public String getRuntimeURI() {
        return this.runtimeURI;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getStatementName() {
        return this.statementName;
    }

    public AuditEnum getCategory() {
        return this.category;
    }

    public int getAgentInstanceId() {
        return this.agentInstanceId;
    }

    public String getMessage() {
        return this.message;
    }

    public String format() {
        return AuditContext.defaultFormat(this.statementName, this.agentInstanceId, this.category, this.message);
    }

    public static String defaultFormat(String statementName, int partition, AuditEnum category, String message) {
        StringBuilder buf = new StringBuilder();
        buf.append("Statement ");
        buf.append(statementName);
        buf.append(" partition ");
        buf.append(partition);
        buf.append(" ");
        buf.append(category.getPrettyPrintText());
        buf.append(" ");
        buf.append(message);
        return buf.toString();
    }
}

