/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.schedule;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.type.CronParameter;
import com.espertech.esper.common.internal.type.ScheduleUnit;
import com.espertech.esper.common.internal.util.IntArrayUtil;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ScheduleSpec {
    private final EnumMap<ScheduleUnit, SortedSet<Integer>> unitValues;
    private String optionalTimeZone;
    private CronParameter optionalDayOfMonthOperator;
    private CronParameter optionalDayOfWeekOperator;

    public ScheduleSpec(EnumMap<ScheduleUnit, SortedSet<Integer>> unitValues, String optionalTimeZone, CronParameter optionalDayOfMonthOperator, CronParameter optionalDayOfWeekOperator) throws IllegalArgumentException {
        ScheduleSpec.validate(unitValues);
        ScheduleSpec.compress(unitValues);
        this.unitValues = unitValues;
        this.optionalTimeZone = optionalTimeZone;
        this.optionalDayOfMonthOperator = optionalDayOfMonthOperator;
        this.optionalDayOfWeekOperator = optionalDayOfWeekOperator;
    }

    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(ScheduleSpec.class, this.getClass(), (CodegenScope)classScope);
        CodegenExpressionRef spec = CodegenExpressionBuilder.ref("spec");
        method.getBlock().declareVar(ScheduleSpec.class, spec.getRef(), CodegenExpressionBuilder.newInstance(ScheduleSpec.class, new CodegenExpression[0]));
        if (this.optionalTimeZone != null) {
            method.getBlock().exprDotMethod(spec, "setOptionalTimeZone", CodegenExpressionBuilder.constant(this.optionalTimeZone));
        }
        for (ScheduleUnit unit : this.unitValues.keySet()) {
            SortedSet<Integer> values = this.unitValues.get((Object)unit);
            CodegenExpression valuesExpr = CodegenExpressionBuilder.constantNull();
            if (values != null) {
                valuesExpr = CodegenExpressionBuilder.newInstance(TreeSet.class, CodegenExpressionBuilder.staticMethod(Arrays.class, "asList", CodegenExpressionBuilder.constant(IntArrayUtil.toBoxedArray(values))));
            }
            method.getBlock().expression(CodegenExpressionBuilder.exprDotMethodChain(spec).add("getUnitValues", new CodegenExpression[0]).add("put", CodegenExpressionBuilder.constant((Object)unit), valuesExpr));
        }
        if (this.optionalDayOfWeekOperator != null) {
            method.getBlock().exprDotMethod(spec, "setOptionalDayOfWeekOperator", this.optionalDayOfWeekOperator.make());
        }
        if (this.optionalDayOfMonthOperator != null) {
            method.getBlock().exprDotMethod(spec, "setOptionalDayOfMonthOperator", this.optionalDayOfMonthOperator.make());
        }
        method.getBlock().methodReturn(spec);
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public ScheduleSpec() {
        this.unitValues = new EnumMap(ScheduleUnit.class);
        this.unitValues.put(ScheduleUnit.MINUTES, null);
        this.unitValues.put(ScheduleUnit.HOURS, null);
        this.unitValues.put(ScheduleUnit.DAYS_OF_MONTH, null);
        this.unitValues.put(ScheduleUnit.MONTHS, null);
        this.unitValues.put(ScheduleUnit.DAYS_OF_WEEK, null);
        this.optionalTimeZone = null;
    }

    public CronParameter getOptionalDayOfMonthOperator() {
        return this.optionalDayOfMonthOperator;
    }

    public CronParameter getOptionalDayOfWeekOperator() {
        return this.optionalDayOfWeekOperator;
    }

    public void setOptionalDayOfMonthOperator(CronParameter optionalDayOfMonthOperator) {
        this.optionalDayOfMonthOperator = optionalDayOfMonthOperator;
    }

    public void setOptionalDayOfWeekOperator(CronParameter optionalDayOfWeekOperator) {
        this.optionalDayOfWeekOperator = optionalDayOfWeekOperator;
    }

    public void setOptionalTimeZone(String optionalTimeZone) {
        this.optionalTimeZone = optionalTimeZone;
    }

    public final EnumMap<ScheduleUnit, SortedSet<Integer>> getUnitValues() {
        return this.unitValues;
    }

    public String getOptionalTimeZone() {
        return this.optionalTimeZone;
    }

    public final void addValue(ScheduleUnit element, int value) {
        SortedSet<Integer> set = this.unitValues.get((Object)element);
        if (set == null) {
            set = new TreeSet<Integer>();
            this.unitValues.put(element, set);
        }
        set.add(value);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        for (ScheduleUnit element : ScheduleUnit.values()) {
            if (!this.unitValues.containsKey((Object)element)) continue;
            Set valueSet = this.unitValues.get((Object)element);
            buffer.append((Object)((Object)element) + "={");
            if (valueSet == null) {
                buffer.append("null");
            } else {
                String delimiter = "";
                Iterator iterator = valueSet.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    buffer.append(delimiter + i);
                    delimiter = ",";
                }
            }
            buffer.append("} ");
        }
        return buffer.toString();
    }

    public final boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null) {
            return false;
        }
        if (this.getClass() != otherObject.getClass()) {
            return false;
        }
        ScheduleSpec other = (ScheduleSpec)otherObject;
        if (this.unitValues.size() != other.unitValues.size()) {
            return false;
        }
        for (Map.Entry<ScheduleUnit, SortedSet<Integer>> entry : this.unitValues.entrySet()) {
            Set mySet = entry.getValue();
            Set otherSet = other.unitValues.get((Object)entry.getKey());
            if (otherSet == null && mySet != null) {
                return false;
            }
            if (otherSet != null && mySet == null) {
                return false;
            }
            if (otherSet == null && mySet == null) continue;
            if (mySet.size() != otherSet.size()) {
                return false;
            }
            Iterator iterator = mySet.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (otherSet.contains(i)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 0;
        for (Map.Entry<ScheduleUnit, SortedSet<Integer>> entry : this.unitValues.entrySet()) {
            if (entry.getValue() == null) continue;
            hashCode *= 31;
            hashCode ^= ((Integer)entry.getValue().iterator().next()).intValue();
        }
        return hashCode;
    }

    protected static void compress(Map<ScheduleUnit, SortedSet<Integer>> unitValues) {
        for (Map.Entry<ScheduleUnit, SortedSet<Integer>> entry : unitValues.entrySet()) {
            int elementValueSetSize = entry.getKey().max() - entry.getKey().min() + 1;
            if (entry.getValue() == null || entry.getValue().size() != elementValueSetSize) continue;
            unitValues.put(entry.getKey(), null);
        }
    }

    protected static void validate(Map<ScheduleUnit, SortedSet<Integer>> unitValues) {
        if (!(unitValues.containsKey((Object)ScheduleUnit.MONTHS) && unitValues.containsKey((Object)ScheduleUnit.DAYS_OF_WEEK) && unitValues.containsKey((Object)ScheduleUnit.HOURS) && unitValues.containsKey((Object)ScheduleUnit.MINUTES) && unitValues.containsKey((Object)ScheduleUnit.DAYS_OF_MONTH))) {
            throw new IllegalArgumentException("Incomplete information for schedule specification, only the following keys are supplied=" + Arrays.toString(unitValues.keySet().toArray()));
        }
        for (ScheduleUnit unit : ScheduleUnit.values()) {
            if ((unit == ScheduleUnit.SECONDS || unit == ScheduleUnit.MILLISECONDS || unit == ScheduleUnit.MICROSECONDS) && !unitValues.containsKey((Object)unit) || unitValues.get((Object)unit) == null) continue;
            SortedSet<Integer> values = unitValues.get((Object)unit);
            for (Integer value : values) {
                if (value >= unit.min() && value <= unit.max()) continue;
                throw new IllegalArgumentException("Invalid value found for schedule unit, value of " + value + " is not valid for unit " + (Object)((Object)unit));
            }
        }
    }
}

