/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.eventtype;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.FragmentEventType;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.event.avro.AvroSchemaEventType;
import com.espertech.esper.common.internal.event.bean.core.BeanEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventType;
import com.espertech.esper.common.internal.event.core.WrapperEventType;
import com.espertech.esper.common.internal.event.json.core.JsonEventType;
import com.espertech.esper.common.internal.event.variant.VariantEventType;
import com.espertech.esper.common.internal.event.xml.BaseXMLEventType;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventPropertyDesc;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventPropertyUtility;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeCompileTimeRegistry;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.StmtClassForgeableBaseNestableEventTypeSerde;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.SerdeCompileTimeResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SerdeEventTypeUtility {
    public static List<StmtClassForgeableFactory> plan(EventType eventType, StatementRawInfo raw, SerdeEventTypeCompileTimeRegistry registry, SerdeCompileTimeResolver resolver) {
        if (!registry.isTargetHA() || registry.getEventTypes().containsKey(eventType) || eventType.getMetadata().getTypeClass() == EventTypeTypeClass.TABLE_INTERNAL) {
            return Collections.emptyList();
        }
        ArrayList<StmtClassForgeableFactory> forgeables = new ArrayList<StmtClassForgeableFactory>(2);
        SerdeEventTypeUtility.planRecursive(forgeables, eventType, raw, registry, resolver);
        return forgeables;
    }

    private static void planRecursive(List<StmtClassForgeableFactory> additionalForgeables, EventType eventType, StatementRawInfo raw, SerdeEventTypeCompileTimeRegistry registry, SerdeCompileTimeResolver resolver) {
        SerdeAndForgeables pair;
        if (!registry.isTargetHA()) {
            return;
        }
        if (registry.getEventTypes().containsKey(eventType)) {
            return;
        }
        if (eventType instanceof BeanEventType) {
            pair = SerdeEventTypeUtility.planBean((BeanEventType)eventType, raw, resolver);
        } else if (eventType instanceof BaseNestableEventType) {
            pair = SerdeEventTypeUtility.planBaseNestable((BaseNestableEventType)eventType, raw, resolver);
            SerdeEventTypeUtility.planPropertiesMayRecurse(eventType, additionalForgeables, raw, registry, resolver);
        } else if (eventType instanceof WrapperEventType) {
            WrapperEventType wrapperEventType = (WrapperEventType)eventType;
            SerdeEventTypeUtility.planRecursive(additionalForgeables, wrapperEventType.getUnderlyingEventType(), raw, registry, resolver);
            pair = SerdeEventTypeUtility.planBaseNestable(wrapperEventType.getUnderlyingMapType(), raw, resolver);
        } else if (eventType instanceof VariantEventType || eventType instanceof AvroSchemaEventType || eventType instanceof BaseXMLEventType) {
            pair = null;
        } else {
            throw new UnsupportedOperationException("Event type not yet handled: " + eventType);
        }
        if (pair != null) {
            registry.addSerdeFor(eventType, pair.forge);
            additionalForgeables.addAll(pair.additionalForgeables);
        }
    }

    private static void planPropertiesMayRecurse(EventType eventType, List<StmtClassForgeableFactory> additionalForgeables, StatementRawInfo raw, SerdeEventTypeCompileTimeRegistry registry, SerdeCompileTimeResolver resolver) {
        for (EventPropertyDescriptor desc : eventType.getPropertyDescriptors()) {
            FragmentEventType fragmentEventType;
            if (!desc.isFragment() || (fragmentEventType = eventType.getFragmentType(desc.getPropertyName())) == null || registry.getEventTypes().containsKey(fragmentEventType.getFragmentType())) continue;
            SerdeEventTypeUtility.planRecursive(additionalForgeables, fragmentEventType.getFragmentType(), raw, registry, resolver);
        }
    }

    private static SerdeAndForgeables planBaseNestable(final BaseNestableEventType eventType, StatementRawInfo raw, SerdeCompileTimeResolver resolver) {
        String className;
        if (eventType instanceof JsonEventType) {
            String classNameFull = ((JsonEventType)eventType).getDetail().getSerdeClassName();
            int lastDotIndex = classNameFull.lastIndexOf(46);
            className = lastDotIndex == -1 ? classNameFull : classNameFull.substring(lastDotIndex + 1);
        } else {
            String uuid = CodeGenerationIDGenerator.generateClassNameUUID();
            className = CodeGenerationIDGenerator.generateClassNameWithUUID(DataInputOutputSerde.class, eventType.getMetadata().getName(), uuid);
        }
        DataInputOutputSerdeForge optionalApplicationSerde = resolver.serdeForEventTypeExternalProvider(eventType, raw);
        if (optionalApplicationSerde != null) {
            return new SerdeAndForgeables(optionalApplicationSerde, Collections.emptyList());
        }
        final DataInputOutputSerdeForge[] forges = new DataInputOutputSerdeForge[eventType.getTypes().size()];
        int count = 0;
        for (Map.Entry<String, Object> property : eventType.getTypes().entrySet()) {
            SerdeEventPropertyDesc desc = SerdeEventPropertyUtility.forgeForEventProperty(eventType, property.getKey(), property.getValue(), raw, resolver);
            forges[count] = desc.getForge();
            ++count;
        }
        StmtClassForgeableFactory forgeable = new StmtClassForgeableFactory(){

            @Override
            public StmtClassForgeable make(CodegenPackageScope packageScope, String classPostfix) {
                return new StmtClassForgeableBaseNestableEventTypeSerde(className, packageScope, eventType, forges);
            }
        };
        DataInputOutputSerdeForge forge = new DataInputOutputSerdeForge(){

            @Override
            public String forgeClassName() {
                return className;
            }

            @Override
            public CodegenExpression codegen(CodegenMethod method, CodegenClassScope classScope, CodegenExpression optionalEventTypeResolver) {
                return CodegenExpressionBuilder.newInstance(className, optionalEventTypeResolver);
            }
        };
        return new SerdeAndForgeables(forge, Collections.singletonList(forgeable));
    }

    private static SerdeAndForgeables planBean(BeanEventType eventType, StatementRawInfo raw, SerdeCompileTimeResolver resolver) {
        DataInputOutputSerdeForge forge = resolver.serdeForBeanEventType(raw, eventType.getUnderlyingType(), eventType.getName(), eventType.getSuperTypes());
        return new SerdeAndForgeables(forge, Collections.emptyList());
    }

    private static class SerdeAndForgeables {
        private final DataInputOutputSerdeForge forge;
        private final List<StmtClassForgeableFactory> additionalForgeables;

        public SerdeAndForgeables(DataInputOutputSerdeForge forge, List<StmtClassForgeableFactory> additionalForgeables) {
            this.forge = forge;
            this.additionalForgeables = additionalForgeables;
        }

        public DataInputOutputSerdeForge getForge() {
            return this.forge;
        }

        public List<StmtClassForgeableFactory> getAdditionalForgeables() {
            return this.additionalForgeables;
        }
    }
}

