/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.resolve;

import com.espertech.esper.common.client.serde.SerdeProvider;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfo;
import com.espertech.esper.common.client.serde.SerdeProviderContextClass;
import com.espertech.esper.common.client.serde.SerdeProvision;
import com.espertech.esper.common.client.serde.SerdeProvisionByClass;
import com.espertech.esper.common.client.serde.SerdeProvisionParameterized;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeException;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIONullableObjectArraySerde;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOSerializableObjectSerde;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.Collection;

public class SerdeCompileTimeResolverUtil {
    protected static SerdeProvision determineSerde(Class type, Collection<SerdeProvider> serdeProviders, boolean allowSerializable, boolean allowExternalizable, boolean allowSerializationFallback, SerdeProviderAdditionalInfo additionalInfo) {
        SerdeProvision serde;
        if (!serdeProviders.isEmpty()) {
            SerdeProvision componentSerde;
            serde = SerdeCompileTimeResolverUtil.determineSerdeFromProviders(type, serdeProviders, additionalInfo);
            if (serde != null) {
                return serde;
            }
            if (type.isArray() && (componentSerde = SerdeCompileTimeResolverUtil.determineSerdeFromProviders(type.getComponentType(), serdeProviders, additionalInfo)) != null) {
                return new SerdeProvisionParameterized(DIONullableObjectArraySerde.class, vars -> CodegenExpressionBuilder.constant(type.getComponentType()), vars -> componentSerde.toForge().codegen(vars.getMethod(), vars.getScope(), vars.getOptionalEventTypeResolver()));
            }
        }
        if ((serde = SerdeCompileTimeResolverUtil.determineSerializable(type, allowExternalizable, allowSerializable, allowSerializationFallback)) != null) {
            return serde;
        }
        throw SerdeCompileTimeResolverUtil.makeFailedToFindException(type, allowExternalizable, allowSerializable, serdeProviders.size(), additionalInfo);
    }

    private static SerdeProvision determineSerdeFromProviders(Class type, Collection<SerdeProvider> serdeProviders, SerdeProviderAdditionalInfo additionalInfo) {
        if (serdeProviders.isEmpty()) {
            return null;
        }
        SerdeProviderContextClass context = new SerdeProviderContextClass(type, additionalInfo);
        for (SerdeProvider provider : serdeProviders) {
            try {
                SerdeProvision serde = provider.resolveSerdeForClass(context);
                if (serde == null) continue;
                return serde;
            }
            catch (DataInputOutputSerdeException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw SerdeCompileTimeResolverUtil.handleProviderRuntimeException(provider, type, ex);
            }
        }
        return null;
    }

    private static SerdeProvision determineSerializable(Class type, boolean allowExternalizable, boolean allowSerializable, boolean allowSerializationFallback) {
        if (allowSerializationFallback) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (JavaClassHelper.isImplementsInterface(type, Externalizable.class) && allowExternalizable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (type.isArray() && JavaClassHelper.isImplementsInterface(type.getComponentType(), Externalizable.class) && allowExternalizable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (JavaClassHelper.isImplementsInterface(type, Serializable.class) && allowSerializable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (type.isArray() && JavaClassHelper.isImplementsInterface(type.getComponentType(), Serializable.class) && allowSerializable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        return null;
    }

    private static DataInputOutputSerdeException handleProviderRuntimeException(SerdeProvider provider, Class type, RuntimeException ex) {
        return new DataInputOutputSerdeException("Unexpected exception invoking serde provider '" + provider.getClass().getName() + "' passing '" + type.getName() + "': " + ex.getMessage(), ex);
    }

    private static DataInputOutputSerdeException makeFailedToFindException(Class clazz, boolean allowExternalizable, boolean allowSerializable, int numSerdeProviders, SerdeProviderAdditionalInfo additionalInfo) {
        return new DataInputOutputSerdeException("Failed to find serde for class '" + JavaClassHelper.getClassNameFullyQualPretty(clazz) + "' for use with " + additionalInfo + " (allowExternalizable=" + allowExternalizable + ",allowSerializable=" + allowSerializable + ",serdeProvider-count=" + numSerdeProviders + ")");
    }
}

