/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.additional;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.collection.SortedRefCountedSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class DIOSortedRefCountedSet
implements DataInputOutputSerde<SortedRefCountedSet<Object>> {
    private final DataInputOutputSerde inner;

    public DIOSortedRefCountedSet(DataInputOutputSerde inner) {
        this.inner = inner;
    }

    @Override
    public void write(SortedRefCountedSet<Object> valueSet, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        output.writeInt(valueSet.getRefSet().size());
        for (Map.Entry<Object, Integer> entry : valueSet.getRefSet().entrySet()) {
            this.inner.write(entry.getKey(), output, unitKey, writer);
            output.writeInt(entry.getValue());
        }
        output.writeLong(valueSet.getCountPoints());
    }

    @Override
    public SortedRefCountedSet<Object> read(DataInput input, byte[] unitKey) throws IOException {
        SortedRefCountedSet<Object> valueSet = new SortedRefCountedSet<Object>();
        TreeMap refSet = valueSet.getRefSet();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = this.inner.read(input, unitKey);
            int ref = input.readInt();
            refSet.put(key, ref);
        }
        valueSet.setCountPoints(input.readLong());
        return valueSet;
    }
}

