/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DIOBigDecimalBigIntegerUtil {
    public static BigDecimal readBigDec(DataInput input) throws IOException {
        int scale = input.readInt();
        BigInteger bigInt = DIOBigDecimalBigIntegerUtil.readBigInt(input);
        return new BigDecimal(bigInt, scale);
    }

    public static void writeBigDec(BigDecimal bigDecimal, DataOutput output) throws IOException {
        output.writeInt(bigDecimal.scale());
        DIOBigDecimalBigIntegerUtil.writeBigInt(bigDecimal.unscaledValue(), output);
    }

    public static void writeBigInt(BigInteger bigInteger, DataOutput stream) throws IOException {
        byte[] a = bigInteger.toByteArray();
        if (a.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("BigInteger byte array is larger than 0x7fff bytes");
        }
        byte firstByte = a[0];
        stream.writeShort(firstByte < 0 ? -a.length : a.length);
        stream.writeByte(firstByte);
        stream.write(a, 1, a.length - 1);
    }

    public static BigInteger readBigInt(DataInput input) throws IOException {
        short len = input.readShort();
        if (len < 0) {
            len = -len;
        }
        byte[] a = new byte[len];
        a[0] = input.readByte();
        input.readFully(a, 1, a.length - 1);
        return new BigInteger(a);
    }
}

