/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIONullableCharacterSerde
implements DataInputOutputSerde<Character> {
    public static final DIONullableCharacterSerde INSTANCE = new DIONullableCharacterSerde();

    private DIONullableCharacterSerde() {
    }

    @Override
    public void write(Character object, DataOutput output, byte[] pageFullKey, EventBeanCollatedWriter writer) throws IOException {
        this.write(object, output);
    }

    public void write(Character object, DataOutput stream) throws IOException {
        boolean isNull = object == null;
        stream.writeBoolean(isNull);
        if (!isNull) {
            stream.writeChar(object.charValue());
        }
    }

    public Character read(DataInput input) throws IOException {
        return this.readInternal(input);
    }

    @Override
    public Character read(DataInput input, byte[] resourceKey) throws IOException {
        return this.readInternal(input);
    }

    private Character readInternal(DataInput input) throws IOException {
        boolean isNull = input.readBoolean();
        if (isNull) {
            return null;
        }
        return Character.valueOf(input.readChar());
    }
}

