/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;

public class DIONullableObjectArraySerde
implements DataInputOutputSerde<Object[]> {
    private final Class componentType;
    private final DataInputOutputSerde componentBinding;

    public DIONullableObjectArraySerde(Class componentType, DataInputOutputSerde componentBinding) {
        this.componentType = componentType;
        this.componentBinding = componentBinding;
    }

    @Override
    public void write(Object[] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        this.writeInternal(object, output, unitKey, writer);
    }

    @Override
    public Object[] read(DataInput input, byte[] unitKey) throws IOException {
        return this.readInternal(input, unitKey);
    }

    private void writeInternal(Object[] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (Object i : object) {
            this.componentBinding.write(i, output, unitKey, writer);
        }
    }

    private Object[] readInternal(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        Object array = Array.newInstance(this.componentType, len);
        for (int i = 0; i < len; ++i) {
            Array.set(array, i, this.componentBinding.read(input, unitKey));
        }
        return (Object[])array;
    }
}

