/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIONullableShortSerde
implements DataInputOutputSerde<Short> {
    public static final DIONullableShortSerde INSTANCE = new DIONullableShortSerde();

    private DIONullableShortSerde() {
    }

    @Override
    public void write(Short object, DataOutput output, byte[] pageFullKey, EventBeanCollatedWriter writer) throws IOException {
        this.write(object, output);
    }

    public void write(Short object, DataOutput stream) throws IOException {
        boolean isNull = object == null;
        stream.writeBoolean(isNull);
        if (!isNull) {
            stream.writeShort(object.shortValue());
        }
    }

    public Short read(DataInput input) throws IOException {
        return this.readInternal(input);
    }

    @Override
    public Short read(DataInput input, byte[] resourceKey) throws IOException {
        return this.readInternal(input);
    }

    private Short readInternal(DataInput input) throws IOException {
        boolean isNull = input.readBoolean();
        if (isNull) {
            return null;
        }
        return input.readShort();
    }
}

