/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOPrimitiveBooleanArray2DimNullableSerde
implements DataInputOutputSerde<boolean[][]> {
    public static final DIOPrimitiveBooleanArray2DimNullableSerde INSTANCE = new DIOPrimitiveBooleanArray2DimNullableSerde();

    private DIOPrimitiveBooleanArray2DimNullableSerde() {
    }

    @Override
    public void write(boolean[][] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (boolean[] i : object) {
            this.writeArray(i, output);
        }
    }

    @Override
    public boolean[][] read(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        boolean[][] array = new boolean[len][];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readArray(input);
        }
        return array;
    }

    private void writeArray(boolean[] array, DataOutput output) throws IOException {
        if (array == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(array.length);
        for (boolean i : array) {
            output.writeBoolean(i);
        }
    }

    private boolean[] readArray(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        boolean[] array = new boolean[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readBoolean();
        }
        return array;
    }
}

