/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOPrimitiveDoubleArray2DimNullableSerde
implements DataInputOutputSerde<double[][]> {
    public static final DIOPrimitiveDoubleArray2DimNullableSerde INSTANCE = new DIOPrimitiveDoubleArray2DimNullableSerde();

    private DIOPrimitiveDoubleArray2DimNullableSerde() {
    }

    @Override
    public void write(double[][] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (double[] i : object) {
            this.writeArray(i, output);
        }
    }

    @Override
    public double[][] read(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        double[][] array = new double[len][];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readArray(input);
        }
        return array;
    }

    private void writeArray(double[] array, DataOutput output) throws IOException {
        if (array == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(array.length);
        for (double i : array) {
            output.writeDouble(i);
        }
    }

    private double[] readArray(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        double[] array = new double[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readDouble();
        }
        return array;
    }
}

