/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import java.io.IOException;
import java.io.InputStream;

public class FastByteArrayInputStream
extends InputStream {
    private byte[] bytes;
    private int length;
    private int offset;
    private int currentMark;

    public FastByteArrayInputStream(byte[] buffer) {
        this.bytes = buffer;
        this.length = buffer.length;
    }

    public FastByteArrayInputStream(byte[] buffer, int offset, int length) {
        this.bytes = buffer;
        this.offset = offset;
        this.length = offset + length;
    }

    public final byte[] getBytes() {
        return this.bytes;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getOffset() {
        return this.offset;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int read(byte[] target, int offset, int length) throws IOException {
        return this.readFast(target, offset, length);
    }

    @Override
    public int available() {
        return this.length - this.offset;
    }

    @Override
    public int read() throws IOException {
        return this.readFast();
    }

    @Override
    public int read(byte[] toBuf) throws IOException {
        return this.readFast(toBuf, 0, toBuf.length);
    }

    @Override
    public void reset() {
        this.offset = this.currentMark;
    }

    @Override
    public long skip(long count) {
        int now = (int)count;
        if (now + this.offset > this.length) {
            now = this.length - this.offset;
        }
        this.skipFast(now);
        return now;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readLimit) {
        this.currentMark = this.offset;
    }

    public final void skipFast(int count) {
        this.offset += count;
    }

    public final int readFast() {
        return this.offset < this.length ? this.bytes[this.offset++] & 0xFF : -1;
    }

    public final int readFast(byte[] target) {
        return this.readFast(target, 0, target.length);
    }

    public final int readFast(byte[] target, int offset, int length) {
        int available = this.length - this.offset;
        if (available <= 0) {
            return -1;
        }
        if (length > available) {
            length = available;
        }
        System.arraycopy(this.bytes, this.offset, target, offset, length);
        this.offset += length;
        return length;
    }
}

