/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.collection.MultiKeyArrayInt;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOMultiKeyArrayIntSerde
implements DataInputOutputSerde<MultiKeyArrayInt> {
    public static final DIOMultiKeyArrayIntSerde INSTANCE = new DIOMultiKeyArrayIntSerde();

    @Override
    public void write(MultiKeyArrayInt mk, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        this.writeInternal(mk.getKeys(), output);
    }

    @Override
    public MultiKeyArrayInt read(DataInput input, byte[] unitKey) throws IOException {
        return new MultiKeyArrayInt(this.readInternal(input));
    }

    private void writeInternal(int[] object, DataOutput output) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (int i : object) {
            output.writeInt(i);
        }
    }

    private int[] readInternal(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readInt();
        }
        return array;
    }
}

