/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.multikey;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.internal.collection.MultiKeyArrayShort;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOMultiKeyArrayShortSerde
implements DataInputOutputSerde<MultiKeyArrayShort> {
    public static final DIOMultiKeyArrayShortSerde INSTANCE = new DIOMultiKeyArrayShortSerde();

    @Override
    public void write(MultiKeyArrayShort mk, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        this.writeInternal(mk.getKeys(), output);
    }

    @Override
    public MultiKeyArrayShort read(DataInput input, byte[] unitKey) throws IOException {
        return new MultiKeyArrayShort(this.readInternal(input));
    }

    private void writeInternal(short[] object, DataOutput output) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (short i : object) {
            output.writeShort(i);
        }
    }

    private short[] readInternal(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        short[] array = new short[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readShort();
        }
        return array;
    }
}

