/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.settings;

import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.util.EnumValue;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class ClasspathImportCompileTimeUtil {
    public static Object resolveIdentAsEnumConst(String constant, ClasspathImportServiceCompileTime classpathImportService, boolean isAnnotation) throws ExprValidationException {
        EnumValue enumValue = ClasspathImportCompileTimeUtil.resolveIdentAsEnum(constant, classpathImportService, isAnnotation);
        if (enumValue == null) {
            return null;
        }
        try {
            return enumValue.getEnumField().get(null);
        }
        catch (IllegalAccessException e) {
            throw new ExprValidationException("Exception accessing field '" + enumValue.getEnumField().getName() + "': " + e.getMessage(), e);
        }
    }

    public static EnumValue resolveIdentAsEnum(String constant, ClasspathImportServiceCompileTime classpathImportService, boolean isAnnotation) {
        Field field;
        Class clazz;
        int lastDotIndex = constant.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        String className = constant.substring(0, lastDotIndex);
        String constName = constant.substring(lastDotIndex + 1);
        className = ClasspathImportCompileTimeUtil.unescape(className);
        constName = ClasspathImportCompileTimeUtil.unescape(constName);
        try {
            clazz = classpathImportService.resolveClass(className, isAnnotation);
        }
        catch (ClasspathImportException e) {
            return null;
        }
        try {
            field = clazz.getField(constName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        int modifiers = field.getModifiers();
        if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
            return new EnumValue(clazz, field);
        }
        return null;
    }

    private static String unescape(String name) {
        if (name.startsWith("`") && name.endsWith("`")) {
            return name.substring(1, name.length() - 1);
        }
        return name;
    }
}

