/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.settings;

import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationMultiFunction;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInSingleRowFunction;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionForge;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.epl.agg.access.linear.AggregationAccessorLinearType;
import com.espertech.esper.common.internal.epl.approx.countminsketch.CountMinSketchAggType;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionCountMinSketchNode;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionLinearAccessNode;
import com.espertech.esper.common.internal.epl.expression.agg.accessagg.ExprAggMultiFunctionSortedMinMaxByNode;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprCountEverNode;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprFirstLastEverNode;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprLeavingAggNode;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprMinMaxAggrNode;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprNthAggNode;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprRateAggNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprCurrentEvaluationContextNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.MinMaxTypeEnum;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprEventIdentityEqualsNode;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.AdvancedIndexFactoryProviderMXCIFQuadTree;
import com.espertech.esper.common.internal.epl.index.advanced.index.quadtree.AdvancedIndexFactoryProviderPointRegionQuadTree;
import com.espertech.esper.common.internal.epl.index.advanced.index.service.AdvancedIndexFactoryProvider;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceBase;
import com.espertech.esper.common.internal.settings.ClasspathImportSingleRowDesc;
import com.espertech.esper.common.internal.settings.ClasspathImportUndefinedException;
import com.espertech.esper.common.internal.util.MethodResolver;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchMethodException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ClasspathImportServiceCompileTime
extends ClasspathImportServiceBase {
    public static final String EXT_SINGLEROW_FUNCTION_TRANSPOSE = "transpose";
    private final MathContext mathContext;
    private final boolean allowExtendedAggregationFunc;
    private final boolean sortUsingCollator;
    private final Map<String, ConfigurationCompilerPlugInAggregationFunction> aggregationFunctions;
    private final List<Pair<Set<String>, ConfigurationCompilerPlugInAggregationMultiFunction>> aggregationAccess;
    private final Map<String, ClasspathImportSingleRowDesc> singleRowFunctions = new HashMap<String, ClasspathImportSingleRowDesc>();
    private final LinkedHashMap<String, AdvancedIndexFactoryProvider> advancedIndexProviders = new LinkedHashMap(8);

    public ClasspathImportServiceCompileTime(Map<String, Object> transientConfiguration, TimeAbacus timeAbacus, Set<String> eventTypeAutoNames, MathContext mathContext, boolean allowExtendedAggregationFunc, boolean sortUsingCollator) {
        super(transientConfiguration, timeAbacus, eventTypeAutoNames);
        this.aggregationFunctions = new HashMap<String, ConfigurationCompilerPlugInAggregationFunction>();
        this.aggregationAccess = new ArrayList<Pair<Set<String>, ConfigurationCompilerPlugInAggregationMultiFunction>>();
        this.mathContext = mathContext;
        this.allowExtendedAggregationFunc = allowExtendedAggregationFunc;
        this.sortUsingCollator = sortUsingCollator;
        this.advancedIndexProviders.put("pointregionquadtree", new AdvancedIndexFactoryProviderPointRegionQuadTree());
        this.advancedIndexProviders.put("mxcifquadtree", new AdvancedIndexFactoryProviderMXCIFQuadTree());
    }

    public void addSingleRow(String functionName, String singleRowFuncClass, String methodName, ConfigurationCompilerPlugInSingleRowFunction.ValueCache valueCache, ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable filterOptimizable, boolean rethrowExceptions, String optionalEventTypeName) throws ClasspathImportException {
        this.validateFunctionName("single-row", functionName);
        if (!ClasspathImportServiceCompileTime.isClassName(singleRowFuncClass)) {
            throw new ClasspathImportException("Invalid class name for aggregation '" + singleRowFuncClass + "'");
        }
        this.singleRowFunctions.put(functionName.toLowerCase(Locale.ENGLISH), new ClasspathImportSingleRowDesc(singleRowFuncClass, methodName, valueCache, filterOptimizable, rethrowExceptions, optionalEventTypeName));
    }

    public Pair<Class, ClasspathImportSingleRowDesc> resolveSingleRow(String name) throws ClasspathImportException, ClasspathImportUndefinedException {
        Class clazz;
        ClasspathImportSingleRowDesc pair = this.singleRowFunctions.get(name);
        if (pair == null) {
            pair = this.singleRowFunctions.get(name.toLowerCase(Locale.ENGLISH));
        }
        if (pair == null) {
            throw new ClasspathImportUndefinedException("A function named '" + name + "' is not defined");
        }
        try {
            clazz = this.getClassForNameProvider().classForName(pair.getClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new ClasspathImportException("Could not load single-row function class by name '" + pair.getClassName() + "'", ex);
        }
        return new Pair<Class, ClasspathImportSingleRowDesc>(clazz, pair);
    }

    public Class resolveAnnotation(String className) throws ClasspathImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, true, true);
        }
        catch (ClassNotFoundException e) {
            throw new ClasspathImportException("Could not load annotation class by name '" + className + "', please check imports", e);
        }
        return clazz;
    }

    public Method resolveMethod(Class clazz, String methodName, Class[] paramTypes, boolean[] allowEventBeanType) throws ClasspathImportException {
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, true, allowEventBeanType, allowEventBeanType);
        }
        catch (MethodResolverNoSuchMethodException e) {
            throw this.convert(clazz, methodName, paramTypes, e, true);
        }
    }

    public Method resolveMethodOverloadChecked(Class clazz, String methodName) throws ClasspathImportException {
        return this.resolveMethodInternalCheckOverloads(clazz, methodName, MethodModifiers.REQUIRE_STATIC_AND_PUBLIC);
    }

    public Method resolveMethodOverloadChecked(String className, String methodName) throws ClasspathImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, false, false);
        }
        catch (ClassNotFoundException e) {
            throw new ClasspathImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        return this.resolveMethodInternalCheckOverloads(clazz, methodName, MethodModifiers.REQUIRE_STATIC_AND_PUBLIC);
    }

    public ExprNode resolveSingleRowExtendedBuiltin(String name) {
        String nameLowerCase = name.toLowerCase(Locale.ENGLISH);
        if (nameLowerCase.equals("current_evaluation_context")) {
            return new ExprCurrentEvaluationContextNode();
        }
        if (nameLowerCase.equals("event_identity_equals")) {
            return new ExprEventIdentityEqualsNode();
        }
        return null;
    }

    public MathContext getDefaultMathContext() {
        return this.mathContext;
    }

    private void validateFunctionName(String functionType, String functionName) throws ClasspathImportException {
        String functionNameLower = functionName.toLowerCase(Locale.ENGLISH);
        if (this.aggregationFunctions.containsKey(functionNameLower)) {
            throw new ClasspathImportException("Aggregation function by name '" + functionName + "' is already defined");
        }
        if (this.singleRowFunctions.containsKey(functionNameLower)) {
            throw new ClasspathImportException("Single-row function by name '" + functionName + "' is already defined");
        }
        for (Pair<Set<String>, ConfigurationCompilerPlugInAggregationMultiFunction> pairs : this.aggregationAccess) {
            if (!pairs.getFirst().contains(functionNameLower)) continue;
            throw new ClasspathImportException("Aggregation multi-function by name '" + functionName + "' is already defined");
        }
        if (!ClasspathImportServiceCompileTime.isFunctionName(functionName)) {
            throw new ClasspathImportException("Invalid " + functionType + " name '" + functionName + "'");
        }
    }

    private static boolean isFunctionName(String functionName) {
        String classNameRegEx = "\\w+";
        return functionName.matches(classNameRegEx);
    }

    public ExprNode resolveAggExtendedBuiltin(String name, boolean isDistinct) {
        if (!this.allowExtendedAggregationFunc) {
            return null;
        }
        String nameLowerCase = name.toLowerCase(Locale.ENGLISH);
        if (nameLowerCase.equals("first")) {
            return new ExprAggMultiFunctionLinearAccessNode(AggregationAccessorLinearType.FIRST);
        }
        if (nameLowerCase.equals("last")) {
            return new ExprAggMultiFunctionLinearAccessNode(AggregationAccessorLinearType.LAST);
        }
        if (nameLowerCase.equals("window")) {
            return new ExprAggMultiFunctionLinearAccessNode(AggregationAccessorLinearType.WINDOW);
        }
        if (nameLowerCase.equals("firstever")) {
            return new ExprFirstLastEverNode(isDistinct, true);
        }
        if (nameLowerCase.equals("lastever")) {
            return new ExprFirstLastEverNode(isDistinct, false);
        }
        if (nameLowerCase.equals("countever")) {
            return new ExprCountEverNode(isDistinct);
        }
        if (nameLowerCase.equals("minever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MIN, false, true);
        }
        if (nameLowerCase.equals("maxever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MAX, false, true);
        }
        if (nameLowerCase.equals("fminever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MIN, true, true);
        }
        if (nameLowerCase.equals("fmaxever")) {
            return new ExprMinMaxAggrNode(isDistinct, MinMaxTypeEnum.MAX, true, true);
        }
        if (nameLowerCase.equals("rate")) {
            return new ExprRateAggNode(isDistinct);
        }
        if (nameLowerCase.equals("nth")) {
            return new ExprNthAggNode(isDistinct);
        }
        if (nameLowerCase.equals("leaving")) {
            return new ExprLeavingAggNode(isDistinct);
        }
        if (nameLowerCase.equals("maxby")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(true, false, false);
        }
        if (nameLowerCase.equals("maxbyever")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(true, true, false);
        }
        if (nameLowerCase.equals("minby")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(false, false, false);
        }
        if (nameLowerCase.equals("minbyever")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(false, true, false);
        }
        if (nameLowerCase.equals("sorted")) {
            return new ExprAggMultiFunctionSortedMinMaxByNode(false, false, true);
        }
        CountMinSketchAggType cmsType = CountMinSketchAggType.fromNameMayMatch(nameLowerCase);
        if (cmsType != null) {
            return new ExprAggMultiFunctionCountMinSketchNode(isDistinct, cmsType);
        }
        return null;
    }

    public boolean isSortUsingCollator() {
        return this.sortUsingCollator;
    }

    public Method resolveNonStaticMethodOverloadChecked(Class clazz, String methodName) throws ClasspathImportException {
        return this.resolveMethodInternalCheckOverloads(clazz, methodName, MethodModifiers.REQUIRE_NONSTATIC_AND_PUBLIC);
    }

    private Method resolveMethodInternalCheckOverloads(Class clazz, String methodName, MethodModifiers methodModifiers) throws ClasspathImportException {
        Method[] methods = clazz.getMethods();
        HashSet<Method> overloadeds = null;
        Method methodByName = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            int modifiers = method.getModifiers();
            boolean isPublic = Modifier.isPublic(modifiers);
            boolean isStatic = Modifier.isStatic(modifiers);
            if (!methodModifiers.acceptsPublicFlag(isPublic) || !methodModifiers.acceptsStaticFlag(isStatic)) continue;
            if (methodByName != null) {
                if (overloadeds == null) {
                    overloadeds = new HashSet<Method>();
                }
                overloadeds.add(method);
                continue;
            }
            methodByName = method;
        }
        if (methodByName == null) {
            throw new ClasspathImportException("Could not find " + methodModifiers.getText() + " method named '" + methodName + "' in class '" + clazz.getName() + "'");
        }
        if (overloadeds == null) {
            return methodByName;
        }
        for (Method overloaded : overloadeds) {
            if (overloaded.getReturnType().equals(methodByName.getReturnType())) continue;
            throw new ClasspathImportException("Method by name '" + methodName + "' is overloaded in class '" + clazz.getName() + "' and overloaded methods do not return the same type");
        }
        return methodByName;
    }

    public AdvancedIndexFactoryProvider resolveAdvancedIndexProvider(String indexTypeName) throws ClasspathImportException {
        AdvancedIndexFactoryProvider provider = this.advancedIndexProviders.get(indexTypeName);
        if (provider == null) {
            throw new ClasspathImportException("Unrecognized advanced-type index '" + indexTypeName + "'");
        }
        return provider;
    }

    public AggregationFunctionForge resolveAggregationFunction(String functionName) throws ClasspathImportUndefinedException, ClasspathImportException {
        Object object;
        Class clazz;
        ConfigurationCompilerPlugInAggregationFunction desc = this.aggregationFunctions.get(functionName);
        if (desc == null) {
            desc = this.aggregationFunctions.get(functionName.toLowerCase(Locale.ENGLISH));
        }
        if (desc == null || desc.getForgeClassName() == null) {
            throw new ClasspathImportUndefinedException("A function named '" + functionName + "' is not defined");
        }
        String className = desc.getForgeClassName();
        try {
            clazz = this.getClassForNameProvider().classForName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new ClasspathImportException("Could not load aggregation factory class by name '" + className + "'", ex);
        }
        try {
            object = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ClasspathImportException("Error instantiating aggregation factory class by name '" + className + "'", e);
        }
        catch (IllegalAccessException e) {
            throw new ClasspathImportException("Illegal access instantiating aggregation factory class by name '" + className + "'", e);
        }
        if (!(object instanceof AggregationFunctionForge)) {
            throw new ClasspathImportException("Class by name '" + className + "' does not implement the " + AggregationFunctionForge.class.getSimpleName() + " interface");
        }
        return (AggregationFunctionForge)object;
    }

    public void addAggregation(String functionName, ConfigurationCompilerPlugInAggregationFunction aggregationDesc) throws ClasspathImportException {
        this.validateFunctionName("aggregation function", functionName);
        if (aggregationDesc.getForgeClassName() == null || !ClasspathImportServiceCompileTime.isClassName(aggregationDesc.getForgeClassName())) {
            throw new ClasspathImportException("Invalid class name for aggregation function forge '" + aggregationDesc.getForgeClassName() + "'");
        }
        this.aggregationFunctions.put(functionName.toLowerCase(Locale.ENGLISH), aggregationDesc);
    }

    public ConfigurationCompilerPlugInAggregationMultiFunction resolveAggregationMultiFunction(String name) {
        for (Pair<Set<String>, ConfigurationCompilerPlugInAggregationMultiFunction> config : this.aggregationAccess) {
            if (!config.getFirst().contains(name.toLowerCase(Locale.ENGLISH))) continue;
            return config.getSecond();
        }
        return null;
    }

    public void addAggregationMultiFunction(ConfigurationCompilerPlugInAggregationMultiFunction desc) throws ClasspathImportException {
        LinkedHashSet<String> orderedImmutableFunctionNames = new LinkedHashSet<String>();
        for (String functionName : desc.getFunctionNames()) {
            orderedImmutableFunctionNames.add(functionName.toLowerCase(Locale.ENGLISH));
            this.validateFunctionName("aggregation multi-function", functionName.toLowerCase(Locale.ENGLISH));
        }
        if (!ClasspathImportServiceCompileTime.isClassName(desc.getMultiFunctionForgeClassName())) {
            throw new ClasspathImportException("Invalid class name for aggregation multi-function factory '" + desc.getMultiFunctionForgeClassName() + "'");
        }
        this.aggregationAccess.add(new Pair(orderedImmutableFunctionNames, desc));
    }

    private static enum MethodModifiers {
        REQUIRE_STATIC_AND_PUBLIC("public static", true),
        REQUIRE_NONSTATIC_AND_PUBLIC("public non-static", false);

        private final String text;
        private final boolean requiredStaticFlag;

        private MethodModifiers(String text, boolean requiredStaticFlag) {
            this.text = text;
            this.requiredStaticFlag = requiredStaticFlag;
        }

        public boolean acceptsPublicFlag(boolean isPublic) {
            return isPublic;
        }

        public boolean acceptsStaticFlag(boolean isStatic) {
            return this.requiredStaticFlag == isStatic;
        }

        public String getText() {
            return this.text;
        }
    }
}

