/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.support;

import com.espertech.esper.common.client.annotation.EventRepresentation;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.client.soda.AnnotationPart;
import com.espertech.esper.common.client.soda.EPStatementObjectModel;
import com.espertech.esper.common.client.util.EventUnderlyingType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Collections;
import java.util.HashSet;

public enum EventRepresentationChoice {
    ARRAY(EventUnderlyingType.OBJECTARRAY, "@EventRepresentation('objectarray')", " objectarray"),
    MAP(EventUnderlyingType.MAP, "@EventRepresentation('map')", " map"),
    AVRO(EventUnderlyingType.AVRO, "@EventRepresentation('avro')", " avro"),
    JSON(EventUnderlyingType.JSON, "@EventRepresentation('json')", " json"),
    DEFAULT(EventUnderlyingType.getDefault(), "", "");

    private final EventUnderlyingType eventRepresentation;
    private final String annotationText;
    private final String outputTypeCreateSchemaName;
    private final String outputTypeClassName;
    private final Class outputTypeClass;

    private EventRepresentationChoice(EventUnderlyingType eventRepresentation, String annotationText, String outputTypeCreateSchemaName) {
        this.eventRepresentation = eventRepresentation;
        this.annotationText = annotationText;
        this.outputTypeCreateSchemaName = outputTypeCreateSchemaName;
        this.outputTypeClassName = eventRepresentation.getUnderlyingClassName();
        this.outputTypeClass = eventRepresentation.getUnderlyingClass();
    }

    public String getUndName() {
        return this.eventRepresentation.name();
    }

    public String getAnnotationText() {
        return this.annotationText;
    }

    public String getOutputTypeCreateSchemaName() {
        return this.outputTypeCreateSchemaName;
    }

    public boolean matchesClass(Class representationType) {
        HashSet<Class> supers = new HashSet<Class>();
        JavaClassHelper.getSuper(representationType, supers);
        supers.add(representationType);
        for (Class clazz : supers) {
            if (!clazz.getName().equals(this.outputTypeClassName) && (this.outputTypeClass == null || !JavaClassHelper.isSubclassOrImplementsInterface(clazz, this.outputTypeClass))) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectArrayEvent() {
        return this == ARRAY;
    }

    public boolean isMapEvent() {
        return this == DEFAULT || this == MAP;
    }

    public String getAnnotationTextForNonMap() {
        if (this == DEFAULT || this == MAP) {
            return "";
        }
        return this.annotationText;
    }

    public void addAnnotationForNonMap(EPStatementObjectModel model) {
        if (this == DEFAULT || this == MAP) {
            return;
        }
        AnnotationPart part = new AnnotationPart(EventRepresentation.class.getSimpleName());
        if (this == ARRAY) {
            part.addValue("objectarray");
        }
        if (this == AVRO) {
            part.addValue("avro");
        }
        if (this == JSON) {
            part.addValue("json");
        }
        model.setAnnotations(Collections.singletonList(part));
    }

    public boolean isAvroEvent() {
        return this == AVRO;
    }

    public boolean isAvroOrJsonEvent() {
        return this == AVRO || this == JSON;
    }

    public static EventRepresentationChoice getEngineDefault(Configuration configuration) {
        EventUnderlyingType configured = configuration.getCommon().getEventMeta().getDefaultEventRepresentation();
        if (configured == EventUnderlyingType.OBJECTARRAY) {
            return ARRAY;
        }
        if (configured == EventUnderlyingType.AVRO) {
            return AVRO;
        }
        return MAP;
    }

    public boolean isJsonEvent() {
        return this == JSON;
    }
}

