/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.support;

public class SupportJavaVersionUtil {
    public static final double JAVA_VERSION = SupportJavaVersionUtil.getVersion();

    public static String getCastMessage(Class from, Class to) {
        if (JAVA_VERSION >= 11.0) {
            return "class " + from.getName() + " cannot be cast to class " + to.getName() + " (" + from.getName() + " and " + to.getName() + " are in module java.base of loader 'bootstrap'";
        }
        if (JAVA_VERSION >= 10.0) {
            return "java.base/" + from.getName() + " cannot be cast to java.base/" + to.getName();
        }
        return from.getName() + " cannot be cast to " + to.getName();
    }

    private static double getVersion() {
        String version = System.getProperty("java.version");
        int pos = version.indexOf(46);
        if (pos == -1) {
            return Double.parseDouble(version);
        }
        pos = version.indexOf(46, pos + 1);
        return Double.parseDouble(version.substring(0, pos));
    }
}

