/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import java.util.Arrays;

public class IntArrayKey {
    private final int[] keys;
    private final int hashCode;

    public IntArrayKey(int[] keys) {
        if (keys == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        this.keys = keys;
        this.hashCode = Arrays.hashCode(keys);
    }

    public final int size() {
        return this.keys.length;
    }

    public final boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof IntArrayKey) {
            IntArrayKey otherKeys = (IntArrayKey)other;
            return Arrays.equals(this.keys, otherKeys.keys);
        }
        return false;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return "IntArrayKey" + Arrays.asList(new int[][]{this.keys}).toString();
    }

    public int[] getKeys() {
        return this.keys;
    }
}

