/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import java.util.Collection;

public class NameAndModule {
    public static final NameAndModule[] EMPTY_ARRAY = new NameAndModule[0];
    private final String name;
    private final String moduleName;

    public NameAndModule(String name, String moduleName) {
        this.name = name;
        this.moduleName = moduleName;
    }

    public String getName() {
        return this.name;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameAndModule that = (NameAndModule)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.moduleName != null ? this.moduleName.equals(that.moduleName) : that.moduleName == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        return result;
    }

    public static CodegenExpression makeArray(Collection<NameAndModule> names) {
        if (names.isEmpty()) {
            return CodegenExpressionBuilder.enumValue(NameAndModule.class, "EMPTY_ARRAY");
        }
        CodegenExpression[] expressions = new CodegenExpression[names.size()];
        int count = 0;
        for (NameAndModule entry : names) {
            expressions[count++] = entry.make();
        }
        return CodegenExpressionBuilder.newArrayWithInit(NameAndModule.class, expressions);
    }

    private CodegenExpression make() {
        return CodegenExpressionBuilder.newInstance(NameAndModule.class, CodegenExpressionBuilder.constant(this.name), CodegenExpressionBuilder.constant(this.moduleName));
    }

    public static NameAndModule findName(String searchForName, NameAndModule[] names) {
        NameAndModule found = null;
        for (NameAndModule item : names) {
            if (!item.getName().equals(searchForName)) continue;
            if (found != null) {
                throw new IllegalStateException("Found multiple entries for name '" + searchForName + "'");
            }
            found = item;
        }
        if (found == null) {
            throw new IllegalStateException("Failed to find name '" + searchForName + "'");
        }
        return found;
    }
}

