/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.NullIterator;
import com.espertech.esper.common.internal.util.StopCallback;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class CollectionUtil {
    public static final String METHOD_SHRINKARRAYEVENTS = "shrinkArrayEvents";
    public static final String METHOD_SHRINKARRAYEVENTARRAY = "shrinkArrayEventArray";
    public static final String METHOD_SHRINKARRAYOBJECTS = "shrinkArrayObjects";
    public static final String METHOD_TOARRAYEVENTS = "toArrayEvents";
    public static final String METHOD_TOARRAYOBJECTS = "toArrayObjects";
    public static final String METHOD_TOARRAYEVENTSARRAY = "toArrayEventsArray";
    public static final String METHOD_TOARRAYNULLFOREMPTYEVENTS = "toArrayNullForEmptyEvents";
    public static final String METHOD_TOARRAYNULLFOREMPTYOBJECTS = "toArrayNullForEmptyObjects";
    public static final String METHOD_TOARRAYNULLFOREMPTYVALUEEVENTS = "toArrayNullForEmptyValueEvents";
    public static final String METHOD_TOARRAYNULLFOREMPTYVALUEVALUES = "toArrayNullForEmptyValueValues";
    public static final String METHOD_TOARRAYMAYNULL = "toArrayMayNull";
    public static final String METHOD_ITERATORTOARRAYEVENTS = "iteratorToArrayEvents";
    public static final Iterator<EventBean> NULL_EVENT_ITERATOR = new NullIterator<EventBean>();
    public static final Iterable<EventBean> NULL_EVENT_ITERABLE = new Iterable<EventBean>(){

        @Override
        public Iterator<EventBean> iterator() {
            return NULL_EVENT_ITERATOR;
        }
    };
    public static final SortedMap EMPTY_SORTED_MAP = new TreeMap();
    public static final EventBean[] EVENTBEANARRAY_EMPTY = new EventBean[0];
    public static final EventBean[][] EVENTBEANARRAYARRAY_EMPTY = new EventBean[0][];
    public static final Set<EventBean> SINGLE_NULL_ROW_EVENT_SET = new HashSet<EventBean>();
    public static final String[] STRINGARRAY_EMPTY = new String[0];
    private static final int MAX_POWER_OF_TWO = 0x40000000;
    public static final Object[] OBJECTARRAY_EMPTY = new Object[0];
    public static final Object[][] OBJECTARRAYARRAY_EMPTY = new Object[0][];
    public static final CodegenExpression EMPTY_LIST_EXPRESSION = CodegenExpressionBuilder.staticMethod(Collections.class, "emptyList", new CodegenExpression[0]);
    public static final StopCallback STOP_CALLBACK_NONE;

    public static String toString(Collection<Integer> stack, String delimiterChars) {
        if (stack.isEmpty()) {
            return "";
        }
        if (stack.size() == 1) {
            return Integer.toString(stack.iterator().next());
        }
        StringWriter writer = new StringWriter();
        String delimiter = "";
        for (Integer item : stack) {
            writer.append(delimiter);
            writer.append(Integer.toString(item));
            delimiter = delimiterChars;
        }
        return writer.toString();
    }

    public static Object arrayExpandAddElements(Object array, Object[] elementsToAdd) {
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int length = Array.getLength(array);
        int newLength = length + elementsToAdd.length;
        Class<?> componentType = array.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newLength);
        System.arraycopy(array, 0, newArray, 0, length);
        for (int i = 0; i < elementsToAdd.length; ++i) {
            Array.set(newArray, length + i, elementsToAdd[i]);
        }
        return newArray;
    }

    public static Object arrayShrinkRemoveSingle(Object array, int index) {
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int length = Array.getLength(array);
        int newLength = length - 1;
        Class<?> componentType = array.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newLength);
        if (index > 0) {
            System.arraycopy(array, 0, newArray, 0, index);
        }
        if (index < newLength) {
            System.arraycopy(array, index + 1, newArray, index, newLength - index);
        }
        return newArray;
    }

    public static Object arrayExpandAddElements(Object array, Collection elementsToAdd) {
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int length = Array.getLength(array);
        int newLength = length + elementsToAdd.size();
        Class<?> componentType = array.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newLength);
        System.arraycopy(array, 0, newArray, 0, length);
        int count = 0;
        for (Object element : elementsToAdd) {
            Array.set(newArray, length + count, element);
            ++count;
        }
        return newArray;
    }

    public static Object arrayExpandAddSingle(Object array, Object elementsToAdd) {
        Class<?> cl = array.getClass();
        if (!cl.isArray()) {
            return null;
        }
        int length = Array.getLength(array);
        int newLength = length + 1;
        Class<?> componentType = array.getClass().getComponentType();
        Object newArray = Array.newInstance(componentType, newLength);
        System.arraycopy(array, 0, newArray, 0, length);
        Array.set(newArray, length, elementsToAdd);
        return newArray;
    }

    public static int[] addValue(int[] ints, int i) {
        int[] copy = new int[ints.length + 1];
        System.arraycopy(ints, 0, copy, 0, ints.length);
        copy[ints.length] = i;
        return copy;
    }

    public static Object[] addValue(Object[] values, Object value) {
        Object[] copy = new Object[values.length + 1];
        System.arraycopy(values, 0, copy, 0, values.length);
        copy[values.length] = value;
        return copy;
    }

    public static int findItem(String[] items, String item) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    public static int[] intArray(Collection<Integer> set) {
        if (set == null) {
            return new int[0];
        }
        int[] result = new int[set.size()];
        int index = 0;
        for (Integer value : set) {
            result[index++] = value;
        }
        return result;
    }

    public static String[] copySortArray(String[] values) {
        if (values == null) {
            return null;
        }
        Object[] copy = new String[values.length];
        System.arraycopy(values, 0, copy, 0, values.length);
        Arrays.sort(copy);
        return copy;
    }

    public static boolean sortCompare(String[] valuesOne, String[] valuesTwo) {
        if (valuesOne == null) {
            return valuesTwo == null;
        }
        if (valuesTwo == null) {
            return false;
        }
        Object[] copyOne = CollectionUtil.copySortArray(valuesOne);
        Object[] copyTwo = CollectionUtil.copySortArray(valuesTwo);
        return Arrays.equals(copyOne, copyTwo);
    }

    public static <T> String toString(Collection<T> collection) {
        if (collection == null) {
            return "null";
        }
        if (collection.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        for (T t : collection) {
            if (t == null) continue;
            buf.append(delimiter);
            buf.append(t);
            delimiter = ", ";
        }
        return buf.toString();
    }

    public static boolean compare(String[] otherIndexProps, String[] thisIndexProps) {
        if (otherIndexProps != null && thisIndexProps != null) {
            return Arrays.equals(otherIndexProps, thisIndexProps);
        }
        return otherIndexProps == null && thisIndexProps == null;
    }

    public static boolean isAllNullArray(Object array) {
        if (array == null) {
            throw new NullPointerException();
        }
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Expected array but received " + array.getClass());
        }
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (Array.get(array, i) == null) continue;
            return false;
        }
        return true;
    }

    public static String toStringArray(Object[] received) {
        StringBuilder buf = new StringBuilder();
        String delimiter = "";
        buf.append("[");
        for (Object t : received) {
            buf.append(delimiter);
            if (t == null) {
                buf.append("null");
            } else if (t instanceof Object[]) {
                buf.append(CollectionUtil.toStringArray((Object[])t));
            } else {
                buf.append(t);
            }
            delimiter = ", ";
        }
        buf.append("]");
        return buf.toString();
    }

    public static Map<String, Object> populateNameValueMap(Object ... values) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int count = values.length / 2;
        if (values.length != count * 2) {
            throw new IllegalArgumentException("Expected an event number of name-value pairs");
        }
        for (int i = 0; i < count; ++i) {
            int index = i * 2;
            Object keyValue = values[index];
            if (!(keyValue instanceof String)) {
                throw new IllegalArgumentException("Expected string-type key value at index " + index + " but found " + keyValue);
            }
            String key = (String)keyValue;
            Object value = values[index + 1];
            if (result.containsKey(key)) {
                throw new IllegalArgumentException("Found two or more values for key '" + key + "'");
            }
            result.put(key, value);
        }
        return result;
    }

    public static Object addArrays(Object first, Object second) {
        if (first != null && !first.getClass().isArray()) {
            throw new IllegalArgumentException("Parameter is not an array: " + first);
        }
        if (second != null && !second.getClass().isArray()) {
            throw new IllegalArgumentException("Parameter is not an array: " + second);
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        int firstLength = Array.getLength(first);
        int secondLength = Array.getLength(second);
        int total = firstLength + secondLength;
        Object dest = Array.newInstance(first.getClass().getComponentType(), total);
        System.arraycopy(first, 0, dest, 0, firstLength);
        System.arraycopy(second, 0, dest, firstLength, secondLength);
        return dest;
    }

    public static EventBean[] toArrayNullForEmptyEvents(Collection<EventBean> events) {
        return events.isEmpty() ? null : events.toArray(new EventBean[events.size()]);
    }

    public static Object[] toArrayNullForEmptyObjects(Collection<Object> values) {
        return values.isEmpty() ? null : values.toArray(new Object[values.size()]);
    }

    public static EventBean[] addArrayWithSetSemantics(EventBean[] arrayOne, EventBean[] arrayTwo) {
        if (arrayOne.length == 0) {
            return arrayTwo;
        }
        if (arrayTwo.length == 0) {
            return arrayOne;
        }
        if (arrayOne.length == 1 && arrayTwo.length == 1) {
            if (arrayOne[0].equals(arrayTwo[0])) {
                return arrayOne;
            }
            return new EventBean[]{arrayOne[0], arrayOne[0]};
        }
        if (arrayOne.length == 1 && arrayTwo.length > 1 && CollectionUtil.searchArray(arrayTwo, arrayOne[0]) != -1) {
            return arrayTwo;
        }
        if (arrayOne.length > 1 && arrayTwo.length == 1 && CollectionUtil.searchArray(arrayOne, arrayTwo[0]) != -1) {
            return arrayOne;
        }
        HashSet<EventBean> set = new HashSet<EventBean>();
        for (EventBean event : arrayOne) {
            set.add(event);
        }
        for (EventBean event : arrayTwo) {
            set.add(event);
        }
        return set.toArray(new EventBean[set.size()]);
    }

    public static String[] toArray(Collection<String> strings) {
        if (strings.isEmpty()) {
            return STRINGARRAY_EMPTY;
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static EventBean[] toArrayEvents(Collection<EventBean> events) {
        if (events.isEmpty()) {
            return EVENTBEANARRAY_EMPTY;
        }
        return events.toArray(new EventBean[events.size()]);
    }

    public static Object[] toArrayObjects(List<Object> values) {
        if (values.isEmpty()) {
            return OBJECTARRAY_EMPTY;
        }
        return values.toArray(new Object[values.size()]);
    }

    public static EventBean[][] toArrayEventsArray(ArrayDeque<EventBean[]> arrays) {
        if (arrays.isEmpty()) {
            return EVENTBEANARRAYARRAY_EMPTY;
        }
        return (EventBean[][])arrays.toArray((T[])new EventBean[arrays.size()][]);
    }

    public static <T> int searchArray(T[] array, T item) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(item)) continue;
            return i;
        }
        return -1;
    }

    public static boolean removeEventByKeyLazyListMap(Object key, EventBean bean, Map<Object, Object> eventMap) {
        Object listOfBeans = eventMap.get(key);
        if (listOfBeans == null) {
            return false;
        }
        if (listOfBeans instanceof List) {
            List events = (List)listOfBeans;
            boolean result = events.remove(bean);
            if (events.isEmpty()) {
                eventMap.remove(key);
            }
            return result;
        }
        if (listOfBeans != null && listOfBeans.equals(bean)) {
            eventMap.remove(key);
            return true;
        }
        return false;
    }

    public static void addEventByKeyLazyListMapBack(Object sortKey, EventBean eventBean, Map<Object, Object> eventMap) {
        Object existing = eventMap.get(sortKey);
        if (existing == null) {
            eventMap.put(sortKey, eventBean);
        } else if (existing instanceof List) {
            List existingList = (List)existing;
            existingList.add(eventBean);
        } else {
            LinkedList<EventBean> existingList = new LinkedList<EventBean>();
            existingList.add((EventBean)existing);
            existingList.add(eventBean);
            eventMap.put(sortKey, existingList);
        }
    }

    public static void addEventByKeyLazyListMapFront(Object key, EventBean bean, Map<Object, Object> eventMap) {
        Object current = eventMap.get(key);
        if (current != null) {
            if (current instanceof List) {
                List events = (List)current;
                events.add(0, bean);
            } else {
                EventBean theEvent = (EventBean)current;
                LinkedList<EventBean> events = new LinkedList<EventBean>();
                events.add(bean);
                events.add(theEvent);
                eventMap.put(key, events);
            }
        } else {
            eventMap.put(key, bean);
        }
    }

    public static boolean isAnySet(boolean[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i]) continue;
            return true;
        }
        return false;
    }

    public static <K, V> Map<K, V> twoEntryMap(K k1, V v1, K k2, V v2) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        map.put(k1, v1);
        map.put(k2, v2);
        return map;
    }

    public static Collection arrayToCollectionAllowNull(Object array) {
        if (array == null) {
            return null;
        }
        if (array instanceof Object[]) {
            return Arrays.asList((Object[])array);
        }
        int len = Array.getLength(array);
        if (len == 0) {
            return Collections.emptyList();
        }
        if (len == 1) {
            return Collections.singletonList(Array.get(array, 0));
        }
        ArrayDeque<Object> dq = new ArrayDeque<Object>(len);
        for (int i = 0; i < len; ++i) {
            dq.add(Array.get(array, i));
        }
        return dq;
    }

    public static Object arrayValueAtIndex(Object array, int index) {
        if (array == null) {
            return null;
        }
        if (Array.getLength(array) <= index) {
            return null;
        }
        return Array.get(array, index);
    }

    public static boolean arrayExistsAtIndex(Object array, int index) {
        if (array == null) {
            return false;
        }
        return Array.getLength(array) > index;
    }

    public static Object mapValueForKey(Map<String, Object> map, String key) {
        return map == null ? null : map.get(key);
    }

    public static boolean mapExistsForKey(Map<String, Object> map, String key) {
        if (map == null) {
            return false;
        }
        return map.containsKey(key);
    }

    public static CodegenExpression arrayToCollectionAllowNullCodegen(CodegenMethodScope codegenMethodScope, Class arrayType, CodegenExpression array, CodegenClassScope codegenClassScope) {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException("Expected array type and received " + arrayType);
        }
        CodegenBlock block = codegenMethodScope.makeChild(Collection.class, CollectionUtil.class, (CodegenScope)codegenClassScope).addParam(arrayType, "array").getBlock().ifRefNullReturnNull("array");
        if (!arrayType.getComponentType().isPrimitive()) {
            return CodegenExpressionBuilder.localMethodBuild(block.methodReturn(CodegenExpressionBuilder.staticMethod(Arrays.class, "asList", CodegenExpressionBuilder.ref("array")))).pass(array).call();
        }
        CodegenMethod method = block.ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.staticMethod(Collections.class, "emptyList", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")), CodegenExpressionBuilder.constant(1))).blockReturn(CodegenExpressionBuilder.staticMethod(Collections.class, "singletonList", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.constant(0)))).declareVar(ArrayDeque.class, "dq", CodegenExpressionBuilder.newInstance(ArrayDeque.class, CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array")))).forLoopIntSimple("i", CodegenExpressionBuilder.arrayLength(CodegenExpressionBuilder.ref("array"))).expression(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("dq"), "add", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref("array"), CodegenExpressionBuilder.ref("i")))).blockEnd().methodReturn(CodegenExpressionBuilder.ref("dq"));
        return CodegenExpressionBuilder.localMethodBuild(method).pass(array).call();
    }

    public static Collection iterableToCollection(Iterable iterable) {
        ArrayList items = new ArrayList();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            items.add(iterator.next());
        }
        return items;
    }

    public static int capacityHashMap(int expectedSize) {
        if (expectedSize < 3) {
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static EventBean[] toArrayMayNull(EventBean event) {
        EventBean[] eventBeanArray;
        if (event != null) {
            EventBean[] eventBeanArray2 = new EventBean[1];
            eventBeanArray = eventBeanArray2;
            eventBeanArray2[0] = event;
        } else {
            eventBeanArray = null;
        }
        return eventBeanArray;
    }

    public static EventBean[] toArrayMayNull(Collection<EventBean> collection) {
        if (collection != null) {
            return collection.toArray(new EventBean[collection.size()]);
        }
        return null;
    }

    public static EventBean[] shrinkArrayEvents(int count, EventBean[] events) {
        EventBean[] outEvents = new EventBean[count];
        System.arraycopy(events, 0, outEvents, 0, count);
        return outEvents;
    }

    public static Object[] shrinkArrayObjects(int count, Object[] keys) {
        Object[] outKeys = new Object[count];
        System.arraycopy(keys, 0, outKeys, 0, count);
        return outKeys;
    }

    public static EventBean[][] shrinkArrayEventArray(int count, EventBean[][] eventArrays) {
        EventBean[][] outGens = new EventBean[count][];
        System.arraycopy(eventArrays, 0, outGens, 0, count);
        return outGens;
    }

    public static EventBean[] toArrayNullForEmptyValueEvents(Map<Object, EventBean> events) {
        return events.isEmpty() ? null : events.values().toArray(new EventBean[events.size()]);
    }

    public static Object[] toArrayNullForEmptyValueValues(Map<Object, Object> values) {
        return values.isEmpty() ? null : values.values().toArray(new Object[values.size()]);
    }

    public static EventBean[] iteratorToArrayEvents(Iterator<EventBean> iterator) {
        if (iterator == null) {
            return null;
        }
        ArrayList<EventBean> events = new ArrayList<EventBean>();
        while (iterator.hasNext()) {
            events.add(iterator.next());
        }
        return events.toArray(new EventBean[events.size()]);
    }

    public static Map<String, Object> buildMap(Object ... pairs) {
        if (pairs.length % 2 != 0) {
            throw new IllegalArgumentException("Requires even number of args");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < pairs.length / 2; ++i) {
            result.put((String)pairs[i * 2], pairs[i * 2 + 1]);
        }
        return result;
    }

    public static Map<String, Object> buildMap(Object[][] entries) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (entries == null) {
            return result;
        }
        for (int i = 0; i < entries.length; ++i) {
            result.put((String)entries[i][0], entries[i][1]);
        }
        return result;
    }

    public static int compareValuesCollated(Object valueOne, Object valueTwo, boolean isDescending, Collator collator) {
        if (valueOne == null || valueTwo == null) {
            if (valueOne == null && valueTwo == null) {
                return 0;
            }
            if (valueOne == null) {
                if (isDescending) {
                    return 1;
                }
                return -1;
            }
            if (isDescending) {
                return -1;
            }
            return 1;
        }
        if (isDescending) {
            return collator.compare(valueTwo, valueOne);
        }
        return collator.compare(valueOne, valueTwo);
    }

    public static int compareValues(Object valueOne, Object valueTwo, boolean isDescending) {
        if (valueOne == null || valueTwo == null) {
            if (valueOne == null && valueTwo == null) {
                return 0;
            }
            if (valueOne == null) {
                if (isDescending) {
                    return 1;
                }
                return -1;
            }
            if (isDescending) {
                return -1;
            }
            return 1;
        }
        if (!(valueOne instanceof Comparable)) {
            throw new ClassCastException("Cannot sort objects of type " + valueOne.getClass());
        }
        Comparable comparable1 = (Comparable)valueOne;
        if (isDescending) {
            return -1 * comparable1.compareTo(valueTwo);
        }
        return comparable1.compareTo(valueTwo);
    }

    public static String[] copyArray(String[] arrayToCopy) {
        if (arrayToCopy.length == 0) {
            return arrayToCopy;
        }
        String[] copy = new String[arrayToCopy.length];
        System.arraycopy(arrayToCopy, 0, copy, 0, copy.length);
        return copy;
    }

    public static String[] appendArrayConditional(String[] appendedTo, boolean test, String appended) {
        if (!test) {
            return appendedTo;
        }
        return CollectionUtil.appendArray(appendedTo, appended);
    }

    public static String[] appendArrayConditional(String appendedTo, boolean test, String appended) {
        if (!test) {
            return new String[]{appendedTo};
        }
        return new String[]{appendedTo, appended};
    }

    public static String[] copyAndSort(String[] input) {
        Object[] result = new String[input.length];
        System.arraycopy(input, 0, result, 0, input.length);
        Arrays.sort(result);
        return result;
    }

    private static String[] appendArray(String[] appendedTo, String appended) {
        String[] result = new String[appendedTo.length + 1];
        System.arraycopy(appendedTo, 0, result, 0, appendedTo.length);
        result[appendedTo.length] = appended;
        return result;
    }

    public static <T> List<List<T>> subdivide(List<T> items, int size) {
        int remainder;
        if (size < 1) {
            throw new IllegalArgumentException("Invalid size " + size);
        }
        if (items.size() <= size) {
            return Collections.singletonList(items);
        }
        ArrayList<List<T>> lists = new ArrayList<List<T>>();
        int start = 0;
        for (remainder = items.size(); remainder > size; remainder -= size) {
            lists.add(items.subList(start, start + size));
            start += size;
        }
        lists.add(items.subList(start, start + remainder));
        return lists;
    }

    static {
        SINGLE_NULL_ROW_EVENT_SET.add(null);
        STOP_CALLBACK_NONE = new StopCallback(){

            @Override
            public void stop() {
            }
        };
    }
}

