/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import java.io.StringWriter;

public final class StringValue {
    public static final String UNNAMED = "(unnamed)";

    public static String parseString(String value) {
        if ((value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) && value.length() > 1) {
            if (value.indexOf(92) != -1) {
                return StringValue.unescape(value.substring(1, value.length() - 1));
            }
            return value.substring(1, value.length() - 1);
        }
        throw new IllegalArgumentException("String value of '" + value + "' cannot be parsed");
    }

    public static int unescapedIndexOfDot(String identifier) {
        int indexof = identifier.indexOf(".");
        if (indexof == -1) {
            return -1;
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char c = identifier.charAt(i);
            if (c != '.' || i > 0 && identifier.charAt(i - 1) == '\\') continue;
            return i;
        }
        return -1;
    }

    protected static String escapeDot(String identifierToEscape) {
        int indexof = identifierToEscape.indexOf(".");
        if (indexof == -1) {
            return identifierToEscape;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < identifierToEscape.length(); ++i) {
            char c = identifierToEscape.charAt(i);
            if (c != '.') {
                builder.append(c);
                continue;
            }
            if (i > 0 && identifierToEscape.charAt(i - 1) == '\\') {
                builder.append('.');
                continue;
            }
            builder.append('\\');
            builder.append('.');
        }
        return builder.toString();
    }

    public static String unescapeDot(String identifierToUnescape) {
        int indexof = identifierToUnescape.indexOf(".");
        if (indexof == -1) {
            return identifierToUnescape;
        }
        indexof = identifierToUnescape.indexOf("\\");
        if (indexof == -1) {
            return identifierToUnescape;
        }
        StringBuilder builder = new StringBuilder();
        int index = -1;
        int max = identifierToUnescape.length() - 1;
        do {
            char c;
            if ((c = identifierToUnescape.charAt(++index)) != '\\') {
                builder.append(c);
                continue;
            }
            if (index >= identifierToUnescape.length() - 1 || identifierToUnescape.charAt(index + 1) != '.') continue;
            builder.append('.');
            ++index;
        } while (index < max);
        return builder.toString();
    }

    public static String unescapeBacktick(String text) {
        int indexof = text.indexOf("`");
        if (indexof == -1) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        int index = -1;
        int max = text.length() - 1;
        boolean skip = false;
        do {
            char c;
            if ((c = text.charAt(++index)) == '`') {
                skip = !skip;
                continue;
            }
            builder.append(c);
        } while (index < max);
        return builder.toString();
    }

    public static void renderConstantAsEPL(StringWriter writer, Object constant) {
        if (constant == null) {
            writer.write("null");
            return;
        }
        if (constant instanceof String || constant instanceof Character) {
            writer.write(34);
            writer.write(constant.toString());
            writer.write(34);
        } else if (constant instanceof Long) {
            writer.write(constant.toString() + "L");
        } else if (constant instanceof Double) {
            writer.write(constant.toString() + "d");
        } else if (constant instanceof Float) {
            writer.write(constant.toString() + "f");
        } else {
            writer.write(constant.toString());
        }
    }

    public static String removeTicks(String tickedString) {
        int indexLast;
        int indexFirst = tickedString.indexOf(96);
        if (indexFirst != (indexLast = tickedString.lastIndexOf(96)) && indexFirst != -1 && indexLast != -1) {
            return tickedString.substring(indexFirst + 1, indexLast);
        }
        return tickedString;
    }

    public static String stringDelimitedTo60Char(String text) {
        if (text == null) {
            return "<null>";
        }
        if (text.length() <= 40) {
            return text;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(text.substring(0, 30));
        buf.append("...(");
        buf.append(Integer.toString(text.length() - 40));
        buf.append(" more)...");
        buf.append(text.substring(text.length() - 15));
        return buf.toString();
    }

    public static String unnamedWhenNullOrEmpty(String value) {
        return value == null || value.trim().isEmpty() ? UNNAMED : value;
    }

    private static String unescape(String s) {
        int i = 0;
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        while (i < len) {
            char c;
            if ((c = s.charAt(i++)) == '\\' && i < len && (c = s.charAt(i++)) == 'u') {
                c = (char)Integer.parseInt(s.substring(i, i + 4), 16);
                i += 4;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

