/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util.apachecommonstext;

import com.espertech.esper.common.internal.util.apachecommonstext.AggregateTranslator;
import com.espertech.esper.common.internal.util.apachecommonstext.CharSequenceTranslator;
import com.espertech.esper.common.internal.util.apachecommonstext.EntityArrays;
import com.espertech.esper.common.internal.util.apachecommonstext.JavaUnicodeEscaper;
import com.espertech.esper.common.internal.util.apachecommonstext.LookupTranslator;
import java.util.Collections;
import java.util.HashMap;

public class StringEscapeUtils {
    public static final CharSequenceTranslator ESCAPE_JAVA;

    public static Builder builder(CharSequenceTranslator translator) {
        return new Builder(translator);
    }

    public static final String escapeJava(String input) {
        return ESCAPE_JAVA.translate(input);
    }

    static {
        HashMap<String, String> escapeJavaMap = new HashMap<String, String>();
        escapeJavaMap.put("\"", "\\\"");
        escapeJavaMap.put("\\", "\\\\");
        ESCAPE_JAVA = new AggregateTranslator(new LookupTranslator(Collections.unmodifiableMap(escapeJavaMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf(32, 127));
    }

    public static final class Builder {
        private final StringBuilder sb = new StringBuilder();
        private final CharSequenceTranslator translator;

        private Builder(CharSequenceTranslator translator) {
            this.translator = translator;
        }

        public Builder append(String input) {
            this.sb.append(input);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

