/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.expr.EventBeanService;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.module.RuntimeExtensionServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.enummethod.cache.ExpressionResultCacheService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.prior.PriorHelper;
import com.espertech.esper.common.internal.epl.script.core.AgentInstanceScriptContext;
import com.espertech.esper.common.internal.epl.table.core.TableExprEvaluatorContext;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.metrics.audit.AuditProvider;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.schedule.SchedulingService;
import com.espertech.esper.common.internal.schedule.TimeProvider;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceRuntime;
import com.espertech.esper.common.internal.settings.ExceptionHandlingService;
import com.espertech.esper.common.internal.settings.RuntimeSettingsService;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperPrevious;
import com.espertech.esper.common.internal.view.access.ViewResourceDelegateDesc;
import com.espertech.esper.common.internal.view.core.DataWindowViewFactory;
import com.espertech.esper.common.internal.view.core.DataWindowViewWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.previous.PreviousGetterStrategy;
import com.espertech.esper.common.internal.view.prior.PriorEventViewFactory;
import java.lang.annotation.Annotation;

public class AgentInstanceViewFactoryChainContext
implements ExprEvaluatorContext {
    private final AgentInstanceContext agentInstanceContext;
    private boolean isRemoveStream;
    private final PreviousGetterStrategy previousNodeGetter;
    private final ViewUpdatedCollection priorViewUpdatedCollection;

    public AgentInstanceViewFactoryChainContext(AgentInstanceContext agentInstanceContext, boolean isRemoveStream, PreviousGetterStrategy previousNodeGetter, ViewUpdatedCollection priorViewUpdatedCollection) {
        this.agentInstanceContext = agentInstanceContext;
        this.isRemoveStream = isRemoveStream;
        this.previousNodeGetter = previousNodeGetter;
        this.priorViewUpdatedCollection = priorViewUpdatedCollection;
    }

    public AgentInstanceContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    public PreviousGetterStrategy getPreviousNodeGetter() {
        return this.previousNodeGetter;
    }

    public ViewUpdatedCollection getPriorViewUpdatedCollection() {
        return this.priorViewUpdatedCollection;
    }

    public StatementContext getStatementContext() {
        return this.agentInstanceContext.getStatementContext();
    }

    @Override
    public String getStatementName() {
        return this.agentInstanceContext.getStatementName();
    }

    @Override
    public Object getUserObjectCompileTime() {
        return this.agentInstanceContext.getUserObjectCompileTime();
    }

    @Override
    public int getStatementId() {
        return this.agentInstanceContext.getStatementId();
    }

    @Override
    public String getDeploymentId() {
        return this.agentInstanceContext.getDeploymentId();
    }

    @Override
    public int getAgentInstanceId() {
        return this.agentInstanceContext.getAgentInstanceId();
    }

    @Override
    public String getRuntimeURI() {
        return this.agentInstanceContext.getRuntimeURI();
    }

    @Override
    public EventBeanService getEventBeanService() {
        return this.agentInstanceContext.getEventBeanService();
    }

    @Override
    public TimeProvider getTimeProvider() {
        return this.agentInstanceContext.getTimeProvider();
    }

    @Override
    public StatementAgentInstanceLock getAgentInstanceLock() {
        return this.agentInstanceContext.getAgentInstanceLock();
    }

    @Override
    public EventBean getContextProperties() {
        return this.agentInstanceContext.getContextProperties();
    }

    @Override
    public TableExprEvaluatorContext getTableExprEvaluatorContext() {
        return this.agentInstanceContext.getTableExprEvaluatorContext();
    }

    public static AgentInstanceViewFactoryChainContext create(ViewFactory[] viewFactoryChain, AgentInstanceContext agentInstanceContext, ViewResourceDelegateDesc viewResourceDelegate) {
        PreviousGetterStrategy previousNodeGetter = null;
        if (viewResourceDelegate.isHasPrevious()) {
            DataWindowViewWithPrevious factoryFound = EPStatementStartMethodHelperPrevious.findPreviousViewFactory(viewFactoryChain);
            previousNodeGetter = factoryFound.makePreviousGetter();
        }
        ViewUpdatedCollection priorViewUpdatedCollection = null;
        if (viewResourceDelegate.getPriorRequests() != null && !viewResourceDelegate.getPriorRequests().isEmpty()) {
            PriorEventViewFactory priorEventViewFactory = PriorHelper.findPriorViewFactory(viewFactoryChain);
            priorViewUpdatedCollection = priorEventViewFactory.makeViewUpdatedCollection(viewResourceDelegate.getPriorRequests(), agentInstanceContext);
        }
        boolean removedStream = false;
        if (viewFactoryChain.length > 1) {
            int countDataWindow = 0;
            for (ViewFactory viewFactory : viewFactoryChain) {
                if (!(viewFactory instanceof DataWindowViewFactory)) continue;
                ++countDataWindow;
            }
            removedStream = countDataWindow > 1;
        }
        return new AgentInstanceViewFactoryChainContext(agentInstanceContext, removedStream, previousNodeGetter, priorViewUpdatedCollection);
    }

    public RuntimeSettingsService getRuntimeSettingsService() {
        return this.agentInstanceContext.getStatementContext().getRuntimeSettingsService();
    }

    public Annotation[] getAnnotations() {
        return this.agentInstanceContext.getStatementContext().getAnnotations();
    }

    public EPStatementAgentInstanceHandle getEpStatementAgentInstanceHandle() {
        return this.agentInstanceContext.getEpStatementAgentInstanceHandle();
    }

    public boolean isRemoveStream() {
        return this.isRemoveStream;
    }

    public SchedulingService getSchedulingService() {
        return this.agentInstanceContext.getSchedulingService();
    }

    public EventBeanTypedEventFactory getEventBeanTypedEventFactory() {
        return this.agentInstanceContext.getEventBeanTypedEventFactory();
    }

    public void setRemoveStream(boolean removeStream) {
        this.isRemoveStream = removeStream;
    }

    public RuntimeExtensionServices getRuntimeExtensionServices() {
        return this.agentInstanceContext.getRuntimeExtensionServicesContext();
    }

    @Override
    public ExpressionResultCacheService getExpressionResultCacheService() {
        return this.agentInstanceContext.getExpressionResultCacheService();
    }

    @Override
    public AgentInstanceScriptContext getAllocateAgentInstanceScriptContext() {
        return this.agentInstanceContext.getAllocateAgentInstanceScriptContext();
    }

    @Override
    public AuditProvider getAuditProvider() {
        return this.agentInstanceContext.getAuditProvider();
    }

    @Override
    public InstrumentationCommon getInstrumentationProvider() {
        return this.agentInstanceContext.getInstrumentationProvider();
    }

    public ClasspathImportServiceRuntime getClasspathImportService() {
        return this.agentInstanceContext.getClasspathImportServiceRuntime();
    }

    @Override
    public ExceptionHandlingService getExceptionHandlingService() {
        return this.agentInstanceContext.getExceptionHandlingService();
    }
}

