/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.EPStatementDispatch;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootMatchRemover;
import com.espertech.esper.common.internal.event.core.FlushedEventBuffer;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class PatternRemoveDispatchView
extends ViewSupport
implements EPStatementDispatch {
    private final EvalRootMatchRemover matchRemoveCallback;
    private final boolean suppressSameEventMatches;
    private final boolean discardPartialsOnMatch;
    private boolean hasData = false;
    private FlushedEventBuffer newDataBuffer = new FlushedEventBuffer();

    public PatternRemoveDispatchView(EvalRootMatchRemover matchRemoveCallback, boolean suppressSameEventMatches, boolean discardPartialsOnMatch) {
        this.matchRemoveCallback = matchRemoveCallback;
        this.suppressSameEventMatches = suppressSameEventMatches;
        this.discardPartialsOnMatch = discardPartialsOnMatch;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.parent.iterator();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.newDataBuffer.add(newData);
        this.hasData = true;
    }

    @Override
    public void execute() {
        if (this.hasData) {
            HashSet<EventBean> events;
            this.hasData = false;
            EventBean[] matches = this.newDataBuffer.getAndFlush();
            if (this.discardPartialsOnMatch) {
                events = new HashSet<EventBean>();
                for (EventBean match : matches) {
                    this.addEventsFromMatch(match, events);
                }
                if (events.size() > 0) {
                    this.matchRemoveCallback.removeMatch(events);
                }
            }
            if (this.suppressSameEventMatches && matches.length > 1) {
                events = new HashSet();
                this.addEventsFromMatch(matches[0], events);
                if (matches.length == 2) {
                    boolean overlaps = this.addEventsFromMatch(matches[1], events);
                    if (overlaps) {
                        matches = new EventBean[]{matches[0]};
                    }
                } else {
                    ArrayList<EventBean> matchesNonOverlapping = new ArrayList<EventBean>(matches.length);
                    matchesNonOverlapping.add(matches[0]);
                    for (int i = 1; i < matches.length; ++i) {
                        HashSet<EventBean> eventsThisMatch = new HashSet<EventBean>();
                        eventsThisMatch.addAll(events);
                        boolean overlaps = this.addEventsFromMatch(matches[i], eventsThisMatch);
                        if (overlaps) continue;
                        events.addAll(eventsThisMatch);
                        matchesNonOverlapping.add(matches[i]);
                    }
                    matches = matchesNonOverlapping.toArray(new EventBean[matchesNonOverlapping.size()]);
                }
            }
            this.child.update(matches, null);
        }
    }

    private boolean addEventsFromMatch(EventBean match, Set<EventBean> events) {
        EventPropertyDescriptor[] properties = match.getEventType().getPropertyDescriptors();
        boolean overlaps = false;
        for (EventPropertyDescriptor desc : properties) {
            EventBean[] arr;
            Object prop = ((Map)match.getUnderlying()).get(desc.getPropertyName());
            if (prop == null) continue;
            if (prop instanceof EventBean) {
                overlaps |= !events.add((EventBean)prop);
                continue;
            }
            if (!(prop instanceof EventBean[])) continue;
            for (EventBean ele : arr = (EventBean[])prop) {
                overlaps |= !events.add(ele);
            }
        }
        return overlaps;
    }
}

