/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.expression;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.variable.core.Variable;
import com.espertech.esper.common.internal.epl.variable.core.VariableChangeCallback;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.expression.ExpressionViewFactoryBase;

public abstract class ExpressionViewBase
extends ViewSupport
implements DataWindowView,
AgentInstanceStopCallback,
VariableChangeCallback {
    protected final ExpressionViewFactoryBase factory;
    protected final ViewUpdatedCollection viewUpdatedCollection;
    protected final ObjectArrayEventBean builtinEventProps;
    protected final EventBean[] eventsPerStream;
    protected final AgentInstanceContext agentInstanceContext;
    protected final long scheduleSlot;
    protected final EPStatementHandleCallbackSchedule scheduleHandle;
    protected final AggregationService aggregationService;

    public abstract void scheduleCallback();

    public ExpressionViewBase(final ExpressionViewFactoryBase factory, ViewUpdatedCollection viewUpdatedCollection, ObjectArrayEventBean builtinEventProps, final AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.factory = factory;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.builtinEventProps = builtinEventProps;
        this.eventsPerStream = new EventBean[]{null, builtinEventProps};
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        if (factory.getVariables() != null && factory.getVariables().length > 0) {
            for (Variable variable : factory.getVariables()) {
                final String variableDepId = variable.getDeploymentId();
                final String variableName = variable.getMetaData().getVariableName();
                final int agentInstanceId = agentInstanceContext.getAgentInstanceId();
                agentInstanceContext.getStatementContext().getVariableManagementService().registerCallback(variable.getDeploymentId(), variableName, agentInstanceId, this);
                agentInstanceContext.getAgentInstanceContext().addTerminationCallback(new AgentInstanceStopCallback(){

                    @Override
                    public void stop(AgentInstanceStopServices services) {
                        services.getAgentInstanceContext().getVariableManagementService().unregisterCallback(variableDepId, variableName, agentInstanceId, ExpressionViewBase.this);
                    }
                });
            }
            ScheduleHandleCallback callback = new ScheduleHandleCallback(){

                @Override
                public void scheduledTrigger() {
                    agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext.getAgentInstanceContext(), ScheduleObjectType.view, factory.getViewName());
                    agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(factory);
                    ExpressionViewBase.this.scheduleCallback();
                    agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
                }
            };
            this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
            this.scheduleHandle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        } else {
            this.scheduleSlot = -1L;
            this.scheduleHandle = null;
        }
        this.aggregationService = factory.getAggregationServiceFactory() != null ? factory.getAggregationServiceFactory().makeService(agentInstanceContext.getAgentInstanceContext(), agentInstanceContext.getClasspathImportService(), false, null, null) : null;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        this.stopScheduleAndVar();
        this.agentInstanceContext.removeTerminationCallback(this);
    }

    private void stopScheduleAndVar() {
        if (this.factory.getVariables() != null && this.factory.getVariables().length > 0) {
            for (Variable variable : this.factory.getVariables()) {
                this.agentInstanceContext.getStatementContext().getVariableManagementService().unregisterCallback(variable.getDeploymentId(), variable.getMetaData().getVariableName(), this.agentInstanceContext.getAgentInstanceId(), this);
            }
            if (this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
                this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.scheduleHandle, ScheduleObjectType.view, this.factory.getViewName());
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.scheduleHandle, this.scheduleSlot);
            }
        }
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getAuditProvider().scheduleAdd(0L, this.agentInstanceContext, this.scheduleHandle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        }
    }

    public ViewUpdatedCollection getViewUpdatedCollection() {
        return this.viewUpdatedCollection;
    }

    public AggregationService getAggregationService() {
        return this.aggregationService;
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

