/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.expression;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScopeNames;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.bytecodemodel.name.CodegenFieldNameViewAgg;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableRSPFactoryProvider;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationResultFuture;
import com.espertech.esper.common.internal.epl.agg.core.AggregationResultFutureAssignableWEval;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryCompiler;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryMakeResult;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceForgeDesc;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.codegen.CodegenLegoMethodExpression;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVariableVisitor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableDeployTimeResolver;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.expression.ExpressionViewOAFieldEnum;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class ExpressionViewForgeBase
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious,
ScheduleHandleCallbackProvider {
    protected ExprNode expiryExpression;
    protected Map<String, VariableMetaData> variableNames;
    protected EventType builtinType;
    protected int scheduleCallbackId = -1;
    protected AggregationServiceForgeDesc aggregationServiceForgeDesc;
    protected int streamNumber;

    protected abstract void makeSetters(CodegenExpressionRef var1, CodegenBlock var2);

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.eventType = parentEventType;
        this.streamNumber = streamNumber;
        LinkedHashMap<String, Object> builtinTypeDef = ExpressionViewOAFieldEnum.asMapOfTypes(this.eventType);
        String outputEventTypeName = viewForgeEnv.getStatementCompileTimeServices().getEventTypeNameGeneratorStatement().getViewExpr(streamNumber);
        EventTypeMetadata metadata = new EventTypeMetadata(outputEventTypeName, viewForgeEnv.getModuleName(), EventTypeTypeClass.VIEWDERIVED, EventTypeApplicationType.OBJECTARR, NameAccessModifier.TRANSIENT, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        LinkedHashMap<String, Object> propertyTypes = EventTypeUtility.getPropertyTypesNonPrimitive(builtinTypeDef);
        this.builtinType = BaseNestableEventUtil.makeOATypeCompileTime(metadata, propertyTypes, null, null, null, null, viewForgeEnv.getBeanEventTypeFactoryProtected(), viewForgeEnv.getEventTypeCompileTimeResolver());
        viewForgeEnv.getEventTypeModuleCompileTimeRegistry().newType(this.builtinType);
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(new EventType[]{this.eventType, this.builtinType}, new String[2], new boolean[2], false, false);
        this.expiryExpression = ViewForgeSupport.validateExpr(this.getViewName(), this.expiryExpression, streamTypeService, viewForgeEnv, 0, streamNumber);
        ExprNodeSummaryVisitor summaryVisitor = new ExprNodeSummaryVisitor();
        this.expiryExpression.accept(summaryVisitor);
        if (summaryVisitor.isHasSubselect() || summaryVisitor.isHasStreamSelect() || summaryVisitor.isHasPreviousPrior()) {
            throw new ViewParameterException("Invalid expiry expression: Sub-select, previous or prior functions are not supported in this context");
        }
        Class returnType = this.expiryExpression.getForge().getEvaluationType();
        if (JavaClassHelper.getBoxedType(returnType) != Boolean.class) {
            throw new ViewParameterException("Invalid return value for expiry expression, expected a boolean return value but received " + JavaClassHelper.getParameterAsString(returnType));
        }
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor(viewForgeEnv.getStatementCompileTimeServices().getVariableCompileTimeResolver());
        this.expiryExpression.accept(visitor);
        this.variableNames = visitor.getVariableNames();
        ArrayList<ExprAggregateNode> aggregateNodes = new ArrayList<ExprAggregateNode>();
        ExprAggregateNodeUtil.getAggregatesBottomUp(this.expiryExpression, aggregateNodes);
        if (!aggregateNodes.isEmpty()) {
            try {
                this.aggregationServiceForgeDesc = AggregationServiceFactoryFactory.getService(Collections.emptyList(), Collections.emptyMap(), Collections.emptyList(), null, null, aggregateNodes, Collections.emptyList(), Collections.emptyList(), false, viewForgeEnv.getAnnotations(), viewForgeEnv.getVariableCompileTimeResolver(), false, null, null, streamTypeService.getEventTypes(), null, viewForgeEnv.getContextName(), null, null, false, false, false, viewForgeEnv.getClasspathImportServiceCompileTime(), viewForgeEnv.getStatementRawInfo(), viewForgeEnv.getSerdeResolver());
            }
            catch (ExprValidationException ex) {
                throw new ViewParameterException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("Schedule callback id not provided");
        }
        CodegenInnerClass evalClass = this.makeExpiryEval(classScope);
        classScope.addInnerClass(evalClass);
        method.getBlock().declareVar(evalClass.getClassName(), "eval", CodegenExpressionBuilder.newInstance(evalClass.getClassName(), new CodegenExpression[0])).exprDotMethod(factory, "setBuiltinMapType", EventTypeUtility.resolveTypeCodegen(this.builtinType, EPStatementInitServices.REF)).exprDotMethod(factory, "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(factory, "setAggregationServiceFactory", this.makeAggregationService(classScope, method, symbols)).exprDotMethod(factory, "setAggregationResultFutureAssignable", CodegenExpressionBuilder.ref("eval")).exprDotMethod(factory, "setExpiryEval", CodegenExpressionBuilder.ref("eval"));
        if (this.variableNames != null && !this.variableNames.isEmpty()) {
            method.getBlock().exprDotMethod(factory, "setVariables", VariableDeployTimeResolver.makeResolveVariables(this.variableNames.values(), symbols.getAddInitSvc(method)));
        }
        this.makeSetters(factory, method.getBlock());
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    private CodegenExpression makeAggregationService(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbol symbols) {
        if (this.aggregationServiceForgeDesc == null) {
            return CodegenExpressionBuilder.constantNull();
        }
        AggregationClassNames aggregationClassNames = new AggregationClassNames(CodegenPackageScopeNames.classPostfixAggregationForView(this.streamNumber));
        AggregationServiceFactoryMakeResult aggResult = AggregationServiceFactoryCompiler.makeInnerClassesAndInit(false, this.aggregationServiceForgeDesc.getAggregationServiceFactoryForge(), parent, classScope, classScope.getOutermostClassName(), aggregationClassNames);
        classScope.addInnerClasses(aggResult.getInnerClasses());
        return CodegenExpressionBuilder.localMethod(aggResult.getInitMethod(), symbols.getAddInitSvc(parent));
    }

    private CodegenInnerClass makeExpiryEval(CodegenClassScope classScope) {
        String classNameExpressionEval = "exprview_eval_" + this.streamNumber;
        CodegenMethod evalMethod = CodegenMethod.makeParentNode(Object.class, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
        CodegenMethod evalMethodCall = CodegenLegoMethodExpression.codegenExpression(this.expiryExpression.getForge(), evalMethod, classScope);
        evalMethod.getBlock().methodReturn(CodegenExpressionBuilder.localMethod(evalMethodCall, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        CodegenMethod assignMethod = CodegenMethod.makeParentNode(Void.TYPE, this.getClass(), (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(AggregationResultFuture.class, "future");
        CodegenExpressionField field = classScope.getPackageScope().addOrGetFieldWellKnown(new CodegenFieldNameViewAgg(this.streamNumber), AggregationResultFuture.class);
        assignMethod.getBlock().assignRef(field, (CodegenExpression)CodegenExpressionBuilder.ref("future"));
        CodegenClassMethods innerMethods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(evalMethod, "evaluate", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(assignMethod, "assign", innerMethods);
        CodegenCtor ctor = new CodegenCtor(StmtClassForgeableRSPFactoryProvider.class, classScope, Collections.emptyList());
        return new CodegenInnerClass(classNameExpressionEval, AggregationResultFutureAssignableWEval.class, ctor, Collections.emptyList(), innerMethods);
    }
}

