/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.exttimedbatch;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodDeltaResult;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.exttimedbatch.ExternallyTimedBatchViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ExternallyTimedBatchView
extends ViewSupport
implements DataWindowView {
    private final ExternallyTimedBatchViewFactory factory;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected EventBean[] lastBatch;
    private Long oldestTimestamp;
    protected final Set<EventBean> window = new LinkedHashSet<EventBean>();
    protected Long referenceTimestamp;
    protected ViewUpdatedCollection viewUpdatedCollection;
    protected AgentInstanceContext agentInstanceContext;
    private final TimePeriodProvide timePeriodProvide;

    public ExternallyTimedBatchView(ExternallyTimedBatchViewFactory factory, ViewUpdatedCollection viewUpdatedCollection, AgentInstanceViewFactoryChainContext agentInstanceContext, TimePeriodProvide timePeriodProvide) {
        this.factory = factory;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.referenceTimestamp = factory.optionalReferencePoint;
        this.timePeriodProvide = timePeriodProvide;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        if (oldData != null && oldData.length != 0) {
            for (EventBean anOldData : oldData) {
                this.window.remove(anOldData);
                this.handleInternalRemovedEvent(anOldData);
            }
            this.determineOldestTimestamp();
        }
        EventBean[] batchNewData = null;
        if (newData != null) {
            for (EventBean newEvent : newData) {
                long timestamp = this.getLongValue(newEvent);
                if (this.referenceTimestamp == null) {
                    this.referenceTimestamp = timestamp;
                }
                if (this.oldestTimestamp == null) {
                    this.oldestTimestamp = timestamp;
                } else {
                    TimePeriodDeltaResult delta = this.timePeriodProvide.deltaAddWReference(this.oldestTimestamp, this.referenceTimestamp, null, true, this.agentInstanceContext);
                    this.referenceTimestamp = delta.getLastReference();
                    if (timestamp - this.oldestTimestamp >= delta.getDelta()) {
                        batchNewData = batchNewData == null ? this.window.toArray(new EventBean[this.window.size()]) : EventBeanUtility.addToArray(batchNewData, this.window);
                        this.window.clear();
                        this.oldestTimestamp = null;
                    }
                }
                this.window.add(newEvent);
                this.handleInternalAddEvent(newEvent, batchNewData != null);
            }
        }
        if (batchNewData != null) {
            this.handleInternalPostBatch(this.window, batchNewData);
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(batchNewData, this.lastBatch);
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, batchNewData, this.lastBatch);
            this.child.update(batchNewData, this.lastBatch);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            this.lastBatch = batchNewData;
            this.determineOldestTimestamp();
        }
        if (oldData != null && oldData.length > 0) {
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldData);
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldData);
            this.child.update(null, oldData);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.window.iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.window, true, this.factory.getViewName(), null);
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }

    protected void determineOldestTimestamp() {
        this.oldestTimestamp = this.window.isEmpty() ? null : Long.valueOf(this.getLongValue(this.window.iterator().next()));
    }

    protected void handleInternalPostBatch(Set<EventBean> window, EventBean[] batchNewData) {
    }

    protected void handleInternalRemovedEvent(EventBean anOldData) {
    }

    protected void handleInternalAddEvent(EventBean anNewData, boolean isNextBatch) {
    }

    private long getLongValue(EventBean obj) {
        this.eventsPerStream[0] = obj;
        Number num = (Number)this.factory.timestampEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        return num.longValue();
    }
}

