/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.firstlength;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.firstlength.FirstLengthWindowViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class FirstLengthWindowView
extends ViewSupport
implements DataWindowView {
    protected final AgentInstanceContext agentInstanceContext;
    private final FirstLengthWindowViewFactory lengthFirstFactory;
    private final int size;
    protected LinkedHashSet<EventBean> indexedEvents;

    public FirstLengthWindowView(AgentInstanceViewFactoryChainContext agentInstanceContext, FirstLengthWindowViewFactory lengthFirstWindowViewFactory, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Illegal argument for size of length window");
        }
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.lengthFirstFactory = lengthFirstWindowViewFactory;
        this.size = size;
        this.indexedEvents = new LinkedHashSet();
    }

    public boolean isEmpty() {
        return this.indexedEvents.isEmpty();
    }

    public final int getSize() {
        return this.size;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.lengthFirstFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.lengthFirstFactory, newData, oldData);
        OneEventCollection newDataToPost = null;
        OneEventCollection oldDataToPost = null;
        if (newData != null) {
            for (EventBean aNewData : newData) {
                if (this.indexedEvents.size() >= this.size) continue;
                if (newDataToPost == null) {
                    newDataToPost = new OneEventCollection();
                }
                newDataToPost.add(aNewData);
                this.indexedEvents.add(aNewData);
            }
        }
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                boolean removed = this.indexedEvents.remove(anOldData);
                if (!removed) continue;
                if (oldDataToPost == null) {
                    oldDataToPost = new OneEventCollection();
                }
                oldDataToPost.add(anOldData);
            }
        }
        if (this.child != null && (newDataToPost != null || oldDataToPost != null)) {
            EventBean[] nd = newDataToPost != null ? newDataToPost.toArray() : null;
            EventBean[] od = oldDataToPost != null ? oldDataToPost.toArray() : null;
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.lengthFirstFactory, nd, od);
            this.child.update(nd, od);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.indexedEvents.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " size=" + this.size;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.indexedEvents, true, this.lengthFirstFactory.getViewName(), null);
    }

    public LinkedHashSet<EventBean> getIndexedEvents() {
        return this.indexedEvents;
    }

    public ViewFactory getViewFactory() {
        return this.lengthFirstFactory;
    }
}

