/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.firsttime;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.firsttime.FirstTimeViewFactory;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class FirstTimeView
extends ViewSupport
implements DataWindowView,
AgentInstanceStopCallback {
    private final FirstTimeViewFactory factory;
    private final AgentInstanceContext agentInstanceContext;
    private EPStatementHandleCallbackSchedule handle;
    private final long scheduleSlot;
    private final TimePeriodProvide timePeriodProvide;
    private LinkedHashSet<EventBean> events = new LinkedHashSet();
    private boolean isClosed;

    public FirstTimeView(FirstTimeViewFactory factory, AgentInstanceViewFactoryChainContext agentInstanceContext, TimePeriodProvide timePeriodProvide) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.factory = factory;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timePeriodProvide = timePeriodProvide;
        this.scheduleCallback();
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        OneEventCollection oldDataToPost = null;
        if (oldData != null) {
            for (EventBean anOldData : oldData) {
                boolean removed = this.events.remove(anOldData);
                if (!removed) continue;
                if (oldDataToPost == null) {
                    oldDataToPost = new OneEventCollection();
                }
                oldDataToPost.add(anOldData);
            }
        }
        OneEventCollection newDataToPost = null;
        if (!this.isClosed && newData != null) {
            for (EventBean aNewData : newData) {
                this.events.add(aNewData);
                if (newDataToPost == null) {
                    newDataToPost = new OneEventCollection();
                }
                newDataToPost.add(aNewData);
            }
        }
        if (this.child != null && (newDataToPost != null || oldDataToPost != null)) {
            EventBean[] nd = newDataToPost != null ? newDataToPost.toArray() : null;
            EventBean[] od = oldDataToPost != null ? oldDataToPost.toArray() : null;
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, nd, od);
            this.child.update(nd, od);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.events.iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    private void scheduleCallback() {
        long afterTime = this.timePeriodProvide.deltaAdd(this.agentInstanceContext.getStatementContext().getSchedulingService().getTime(), null, true, this.agentInstanceContext);
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                FirstTimeView.this.agentInstanceContext.getAuditProvider().scheduleFire(FirstTimeView.this.agentInstanceContext, ScheduleObjectType.view, FirstTimeView.this.factory.getViewName());
                FirstTimeView.this.agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(FirstTimeView.this.factory);
                FirstTimeView.this.isClosed = true;
                FirstTimeView.this.agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        this.agentInstanceContext.getAuditProvider().scheduleAdd(afterTime, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(afterTime, this.handle, this.scheduleSlot);
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.handle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    public void setClosed(boolean closed) {
        this.isClosed = closed;
    }

    public LinkedHashSet<EventBean> getEvents() {
        return this.events;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.events, true, this.factory.getViewName(), null);
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

