/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.groupwin;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.util.ExecutionPathDebugLog;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewDataVisitorContained;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.groupwin.GroupByView;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewAgedEntry;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewFactory;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewImpl;
import com.espertech.esper.common.internal.view.groupwin.GroupByViewUtil;
import com.espertech.esper.common.internal.view.groupwin.MergeView;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByViewReclaimAged
extends ViewSupport
implements GroupByView,
AgentInstanceStopCallback {
    private final GroupByViewFactory groupByViewFactory;
    private final AgentInstanceViewFactoryChainContext agentInstanceContext;
    private final MergeView mergeView;
    private EventBean[] eventsPerStream = new EventBean[1];
    protected final Map<Object, GroupByViewAgedEntry> subViewPerKey = new HashMap<Object, GroupByViewAgedEntry>();
    private final HashMap<GroupByViewAgedEntry, Pair<Object, Object>> groupedEvents = new HashMap();
    private Long nextSweepTime = null;
    private static final Logger log = LoggerFactory.getLogger(GroupByViewReclaimAged.class);

    public GroupByViewReclaimAged(GroupByViewFactory groupByViewFactory, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        this.groupByViewFactory = groupByViewFactory;
        this.agentInstanceContext = agentInstanceContext;
        this.mergeView = new MergeView(this, groupByViewFactory.eventType);
    }

    @Override
    public GroupByViewFactory getViewFactory() {
        return this.groupByViewFactory;
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        AgentInstanceContext aiContext = this.agentInstanceContext.getAgentInstanceContext();
        aiContext.getAuditProvider().view(newData, oldData, aiContext, this.groupByViewFactory);
        aiContext.getInstrumentationProvider().qViewProcessIRStream(this.groupByViewFactory, newData, oldData);
        long currentTime = this.agentInstanceContext.getTimeProvider().getTime();
        if (this.nextSweepTime == null || this.nextSweepTime <= currentTime) {
            if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
                log.debug("Reclaiming groups older then " + this.groupByViewFactory.getReclaimMaxAge() + " msec and every " + this.groupByViewFactory.getReclaimFrequency() + "msec in frequency");
            }
            this.nextSweepTime = currentTime + this.groupByViewFactory.getReclaimFrequency();
            this.sweep(currentTime);
        }
        if (newData != null && oldData == null && newData.length == 1) {
            EventBean theEvent = newData[0];
            Object object = this.getGroupKey(theEvent);
            GroupByViewAgedEntry subView = this.subViewPerKey.get(object);
            if (subView == null) {
                View subview = GroupByViewUtil.makeSubView(this, object);
                subView = new GroupByViewAgedEntry(subview, currentTime);
                this.subViewPerKey.put(object, subView);
            } else {
                subView.setLastUpdateTime(currentTime);
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.groupByViewFactory, newData, null);
            subView.getSubview().update(newData, null);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        } else {
            if (newData != null) {
                for (EventBean newValue : newData) {
                    this.handleEvent(newValue, true);
                }
            }
            if (oldData != null) {
                for (EventBean oldValue : oldData) {
                    this.handleEvent(oldValue, false);
                }
            }
            for (Map.Entry entry : this.groupedEvents.entrySet()) {
                EventBean[] newEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getFirst());
                EventBean[] oldEvents = GroupByViewImpl.convertToArray(((Pair)entry.getValue()).getSecond());
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.groupByViewFactory, newEvents, oldEvents);
                ((GroupByViewAgedEntry)entry.getKey()).getSubview().update(newEvents, oldEvents);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
            this.groupedEvents.clear();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    private void handleEvent(EventBean theEvent, boolean isNew) {
        Object groupByValuesKey = this.getGroupKey(theEvent);
        GroupByViewAgedEntry subViews = this.subViewPerKey.get(groupByValuesKey);
        if (subViews == null) {
            View subview = GroupByViewUtil.makeSubView(this, groupByValuesKey);
            long currentTime = this.agentInstanceContext.getStatementContext().getTimeProvider().getTime();
            subViews = new GroupByViewAgedEntry(subview, currentTime);
            this.subViewPerKey.put(groupByValuesKey, subViews);
        } else {
            subViews.setLastUpdateTime(this.agentInstanceContext.getStatementContext().getTimeProvider().getTime());
        }
        Pair<Object, Object> pair = this.groupedEvents.get(subViews);
        if (pair == null) {
            pair = new Pair<Object, Object>(null, null);
            this.groupedEvents.put(subViews, pair);
        }
        if (isNew) {
            pair.setFirst(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getFirst(), theEvent));
        } else {
            pair.setSecond(GroupByViewImpl.addUpgradeToDequeIfPopulated(pair.getSecond(), theEvent));
        }
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.mergeView.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " groupFieldNames=" + Arrays.toString(this.groupByViewFactory.getPropertyNames());
    }

    @Override
    public AgentInstanceViewFactoryChainContext getAgentInstanceContext() {
        return this.agentInstanceContext;
    }

    @Override
    public MergeView getMergeView() {
        return this.mergeView;
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.groupByViewFactory.getViewName(), this.subViewPerKey.size());
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewPerKey.entrySet()) {
            GroupByViewImpl.visitView(viewDataVisitor, entry.getKey(), entry.getValue().getSubview());
        }
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewPerKey.entrySet()) {
            GroupByViewUtil.removeSubview(entry.getValue().getSubview(), services);
        }
    }

    private void sweep(long currentTime) {
        ArrayDeque<Object> removed = new ArrayDeque<Object>();
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : this.subViewPerKey.entrySet()) {
            long age = currentTime - entry.getValue().getLastUpdateTime();
            if (age <= this.groupByViewFactory.getReclaimMaxAge()) continue;
            removed.add(entry.getKey());
        }
        for (Map.Entry<Object, GroupByViewAgedEntry> entry : removed) {
            GroupByViewAgedEntry entry2 = this.subViewPerKey.remove(entry);
            GroupByViewUtil.removeSubview(entry2.getSubview(), new AgentInstanceStopServices(this.agentInstanceContext.getAgentInstanceContext()));
        }
    }

    private Object getGroupKey(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        return this.groupByViewFactory.getCriteriaEval().evaluate(this.eventsPerStream, true, this.agentInstanceContext);
    }
}

