/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.prior;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.RollingEventBuffer;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.view.access.RelativeAccessByEventNIndex;
import com.espertech.esper.common.internal.view.prior.PriorEventBufferChangeCaptureMulti;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PriorEventBufferMulti
implements ViewUpdatedCollection,
RelativeAccessByEventNIndex {
    private final int priorToIndexesSize;
    private final int[] priorToIndexes;
    private final Map<EventBean, EventBean[]> priorEventMap;
    private final RollingEventBuffer newEvents;
    private EventBean[] lastOldData;

    public PriorEventBufferMulti(int[] priorToIndexSet) {
        int n;
        int maxPriorIndex = 0;
        int[] nArray = priorToIndexSet;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer priorIndex = nArray[n];
            if (priorIndex <= maxPriorIndex) continue;
            maxPriorIndex = priorIndex;
        }
        this.priorToIndexesSize = priorToIndexSet.length;
        this.priorToIndexes = new int[this.priorToIndexesSize];
        int count = 0;
        int[] nArray2 = priorToIndexSet;
        n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            Integer priorIndex = nArray2[i];
            this.priorToIndexes[count++] = priorIndex;
        }
        Arrays.sort(this.priorToIndexes);
        this.newEvents = new RollingEventBuffer(maxPriorIndex + 1);
        this.priorEventMap = new HashMap<EventBean, EventBean[]>();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                this.priorEventMap.remove(this.lastOldData[i]);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean[] priorEvents = new EventBean[this.priorToIndexesSize];
                for (int j = 0; j < this.priorToIndexesSize; ++j) {
                    int priorIndex = this.priorToIndexes[j];
                    priorEvents[j] = this.newEvents.get(priorIndex);
                }
                this.priorEventMap.put(newEvent, priorEvents);
            }
        }
        this.lastOldData = oldData;
    }

    public void update(EventBean[] newData, EventBean[] oldData, PriorEventBufferChangeCaptureMulti capture) {
        int i;
        if (this.lastOldData != null) {
            for (i = 0; i < this.lastOldData.length; ++i) {
                EventBean oldDataItem = this.lastOldData[i];
                this.priorEventMap.remove(oldDataItem);
                capture.removed(oldDataItem);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                this.newEvents.add(newEvent);
                EventBean[] priorEvents = new EventBean[this.priorToIndexesSize];
                for (int j = 0; j < this.priorToIndexesSize; ++j) {
                    int priorIndex = this.priorToIndexes[j];
                    priorEvents[j] = this.newEvents.get(priorIndex);
                }
                this.priorEventMap.put(newEvent, priorEvents);
                capture.added(newEvent, priorEvents);
            }
        }
        this.lastOldData = oldData;
    }

    @Override
    public EventBean getRelativeToEvent(EventBean theEvent, int priorToIndex) {
        if (priorToIndex >= this.priorToIndexesSize) {
            throw new IllegalArgumentException("Index " + priorToIndex + " not allowed, max size is " + this.priorToIndexesSize);
        }
        EventBean[] priorEvents = this.priorEventMap.get(theEvent);
        if (priorEvents == null) {
            throw new IllegalStateException("Event not currently in collection, event=" + theEvent);
        }
        return priorEvents[priorToIndex];
    }

    @Override
    public EventBean getRelativeToEnd(int index) {
        return null;
    }

    @Override
    public int getWindowToEventCount() {
        return 0;
    }

    @Override
    public Iterator<EventBean> getWindowToEvent() {
        return null;
    }

    @Override
    public Collection<EventBean> getWindowToEventCollReadOnly() {
        return null;
    }

    @Override
    public void destroy() {
    }

    public Map<EventBean, EventBean[]> getPriorEventMap() {
        return this.priorEventMap;
    }

    public RollingEventBuffer getNewEvents() {
        return this.newEvents;
    }

    @Override
    public int getNumEventsInsertBuf() {
        return this.newEvents.getSize();
    }
}

