/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.rank;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprConstantNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.epl.expression.core.ExprOrderedExpr;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewEnum;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.rank.RankWindowViewFactory;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import com.espertech.esper.common.internal.view.util.ViewMultiKeyHelper;
import java.util.List;

public class RankWindowViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious {
    private List<ExprNode> viewParameters;
    protected ExprNode[] criteriaExpressions;
    protected ExprNode[] sortCriteriaExpressions;
    protected boolean[] isDescendingValues;
    protected ExprForge sizeForge;
    protected boolean useCollatorSort;
    protected MultiKeyClassRef multiKeyClassNames;
    protected DataInputOutputSerdeForge[] sortSerdes;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.viewParameters = parameters;
        this.useCollatorSort = viewForgeEnv.getConfiguration().getCompiler().getLanguage().isSortUsingCollator();
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        int i;
        this.eventType = parentEventType;
        String message = this.getViewName() + " view requires a list of expressions providing unique keys, a numeric size parameter and a list of expressions providing sort keys";
        if (this.viewParameters.size() < 3) {
            throw new ViewParameterException(message);
        }
        ExprNode[] validated = ViewForgeSupport.validate(this.getViewName(), parentEventType, this.viewParameters, true, viewForgeEnv, streamNumber);
        int indexNumericSize = -1;
        for (i = 0; i < validated.length; ++i) {
            if (!(validated[i] instanceof ExprConstantNode) && !(validated[i] instanceof ExprContextPropertyNode)) continue;
            indexNumericSize = i;
            break;
        }
        if (indexNumericSize == -1) {
            throw new ViewParameterException("Failed to find constant value for the numeric size parameter");
        }
        if (indexNumericSize == 0) {
            throw new ViewParameterException("Failed to find unique value expressions that are expected to occur before the numeric size parameter");
        }
        if (indexNumericSize == validated.length - 1) {
            throw new ViewParameterException("Failed to find sort key expressions after the numeric size parameter");
        }
        for (i = 0; i < indexNumericSize; ++i) {
            ViewForgeSupport.assertReturnsNonConstant(this.getViewName(), validated[i], i);
        }
        for (i = indexNumericSize + 1; i < validated.length; ++i) {
            ViewForgeSupport.assertReturnsNonConstant(this.getViewName(), validated[i], i);
        }
        ViewForgeSupport.validateNoProperties(this.getViewName(), validated[indexNumericSize], indexNumericSize);
        this.sizeForge = ViewForgeSupport.validateSizeParam(this.getViewName(), validated[indexNumericSize], indexNumericSize);
        this.criteriaExpressions = new ExprNode[indexNumericSize];
        System.arraycopy(validated, 0, this.criteriaExpressions, 0, indexNumericSize);
        this.sortCriteriaExpressions = new ExprNode[validated.length - indexNumericSize - 1];
        this.isDescendingValues = new boolean[this.sortCriteriaExpressions.length];
        int count = 0;
        for (int i2 = indexNumericSize + 1; i2 < validated.length; ++i2) {
            if (validated[i2] instanceof ExprOrderedExpr) {
                this.isDescendingValues[count] = ((ExprOrderedExpr)validated[i2]).isDescending();
                this.sortCriteriaExpressions[count] = validated[i2].getChildNodes()[0];
            } else {
                this.sortCriteriaExpressions[count] = validated[i2];
            }
            ++count;
        }
        this.sortSerdes = viewForgeEnv.getSerdeResolver().serdeForDataWindowSortCriteria(ExprNodeUtilityQuery.getExprResultTypes(this.sortCriteriaExpressions), viewForgeEnv.getStatementRawInfo());
    }

    @Override
    public List<StmtClassForgeableFactory> initAdditionalForgeables(ViewForgeEnv viewForgeEnv) {
        MultiKeyPlan desc = MultiKeyPlanner.planMultiKey(this.criteriaExpressions, false, viewForgeEnv.getStatementRawInfo(), viewForgeEnv.getStatementCompileTimeServices().getSerdeResolver());
        this.multiKeyClassNames = desc.getClassRef();
        return desc.getMultiKeyForgeables();
    }

    @Override
    protected Class typeOfFactory() {
        return RankWindowViewFactory.class;
    }

    @Override
    protected String factoryMethod() {
        return "rank";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(factory, "setSize", ExprNodeUtilityCodegen.codegenEvaluator(this.sizeForge, method, this.getClass(), classScope)).exprDotMethod(factory, "setSortCriteriaEvaluators", ExprNodeUtilityCodegen.codegenEvaluators(this.sortCriteriaExpressions, (CodegenMethodScope)method, this.getClass(), classScope)).exprDotMethod(factory, "setSortCriteriaTypes", CodegenExpressionBuilder.constant(ExprNodeUtilityQuery.getExprResultTypes(this.sortCriteriaExpressions))).exprDotMethod(factory, "setIsDescendingValues", CodegenExpressionBuilder.constant(this.isDescendingValues)).exprDotMethod(factory, "setUseCollatorSort", CodegenExpressionBuilder.constant(this.useCollatorSort)).exprDotMethod(factory, "setSortSerdes", DataInputOutputSerdeForge.codegenArray(this.sortSerdes, method, classScope, null));
        ViewMultiKeyHelper.assign(this.criteriaExpressions, this.multiKeyClassNames, method, factory, symbols, classScope);
    }

    @Override
    public String getViewName() {
        return ViewEnum.RANK_WINDOW.getName();
    }
}

