/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.time_accum;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.time_accum.TimeAccumViewFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class TimeAccumView
extends ViewSupport
implements DataWindowView,
AgentInstanceStopCallback {
    private final TimeAccumViewFactory factory;
    private final AgentInstanceContext agentInstanceContext;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final long scheduleSlot;
    private final TimePeriodProvide timePeriodProvide;
    private ArrayList<EventBean> currentBatch = new ArrayList();
    private long callbackScheduledTime;
    private EPStatementHandleCallbackSchedule handle;

    public TimeAccumView(TimeAccumViewFactory timeBatchViewFactory, final AgentInstanceViewFactoryChainContext agentInstanceContext, ViewUpdatedCollection viewUpdatedCollection, TimePeriodProvide timePeriodProvide) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.factory = timeBatchViewFactory;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timePeriodProvide = timePeriodProvide;
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext.getAgentInstanceContext(), ScheduleObjectType.view, TimeAccumView.this.factory.getViewName());
                agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(TimeAccumView.this.factory);
                TimeAccumView.this.sendRemoveStream();
                agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        if (newData == null || newData.length == 0) {
            return;
        }
        boolean removeSchedule = false;
        boolean addSchedule = false;
        long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        if (!this.currentBatch.isEmpty()) {
            long callbackTime = timestamp + this.timePeriodProvide.deltaAdd(timestamp, null, true, this.agentInstanceContext);
            if (callbackTime != this.callbackScheduledTime) {
                removeSchedule = true;
                addSchedule = true;
            }
        } else {
            addSchedule = true;
        }
        if (removeSchedule) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
        if (addSchedule) {
            long timeIntervalSize = this.timePeriodProvide.deltaAdd(timestamp, null, true, this.agentInstanceContext);
            this.agentInstanceContext.getAuditProvider().scheduleAdd(timeIntervalSize, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(timeIntervalSize, this.handle, this.scheduleSlot);
            this.callbackScheduledTime = timeIntervalSize + timestamp;
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, null);
        }
        if (this.child != null) {
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, null);
            this.child.update(newData, null);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    private void sendRemoveStream() {
        this.callbackScheduledTime = -1L;
        if (this.child != null) {
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                oldData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(null, oldData);
            }
            if (oldData != null) {
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldData);
                this.child.update(null, oldData);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
        }
        this.currentBatch.clear();
    }

    public boolean isEmpty() {
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.handle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.factory.getViewName(), null);
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

