/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timelengthbatch;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.timelengthbatch.TimeLengthBatchViewFactory;
import java.util.ArrayList;
import java.util.Iterator;

public class TimeLengthBatchView
extends ViewSupport
implements AgentInstanceStopCallback,
DataWindowView {
    private final TimeLengthBatchViewFactory factory;
    private final AgentInstanceContext agentInstanceContext;
    private final ViewUpdatedCollection viewUpdatedCollection;
    private final int size;
    private final long scheduleSlot;
    private final TimePeriodProvide timePeriodProvide;
    protected ArrayList<EventBean> lastBatch = null;
    protected ArrayList<EventBean> currentBatch = new ArrayList();
    protected Long callbackScheduledTime;
    protected EPStatementHandleCallbackSchedule handle;

    public TimeLengthBatchView(TimeLengthBatchViewFactory factory, int size, AgentInstanceViewFactoryChainContext agentInstanceContext, ViewUpdatedCollection viewUpdatedCollection, TimePeriodProvide timePeriodProvide) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.factory = factory;
        this.size = size;
        this.viewUpdatedCollection = viewUpdatedCollection;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timePeriodProvide = timePeriodProvide;
        if (factory.isStartEager()) {
            this.scheduleCallback(0L);
        }
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                if (!this.currentBatch.remove(oldData[i])) continue;
                this.internalHandleRemoved(oldData[i]);
            }
        }
        if (newData == null || newData.length == 0) {
            this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
            return;
        }
        for (EventBean newEvent : newData) {
            this.currentBatch.add(newEvent);
            this.internalHandleAdded(newEvent);
        }
        if (this.currentBatch.size() < this.size) {
            if (this.callbackScheduledTime == null) {
                this.scheduleCallback(0L);
            }
            this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
            return;
        }
        this.sendBatch(false);
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    public void internalHandleAdded(EventBean newEvent) {
    }

    public void internalHandleRemoved(EventBean eventBean) {
    }

    protected void sendBatch(boolean isFromSchedule) {
        if (isFromSchedule) {
            this.callbackScheduledTime = null;
        } else if (this.callbackScheduledTime != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
            this.callbackScheduledTime = null;
        }
        if (this.child != null) {
            EventBean[] newData = null;
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                newData = this.currentBatch.toArray(new EventBean[this.currentBatch.size()]);
            }
            if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
                oldData = this.lastBatch.toArray(new EventBean[this.lastBatch.size()]);
            }
            if (this.viewUpdatedCollection != null) {
                this.viewUpdatedCollection.update(newData, oldData);
            }
            if (newData != null || oldData != null || this.factory.isForceUpdate()) {
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, oldData);
                this.child.update(newData, oldData);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
        }
        if (!this.currentBatch.isEmpty() || this.lastBatch != null && !this.lastBatch.isEmpty() || this.factory.isForceUpdate) {
            this.scheduleCallback(0L);
        }
        this.lastBatch = this.currentBatch;
        this.currentBatch = new ArrayList();
    }

    public boolean isEmpty() {
        if (this.lastBatch != null && !this.lastBatch.isEmpty()) {
            return false;
        }
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.iterator();
    }

    public final String toString() {
        return this.getClass().getName() + " numberOfEvents=" + this.size;
    }

    protected void scheduleCallback(long delta) {
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                TimeLengthBatchView.this.agentInstanceContext.getAuditProvider().scheduleFire(TimeLengthBatchView.this.agentInstanceContext, ScheduleObjectType.view, TimeLengthBatchView.this.factory.getViewName());
                TimeLengthBatchView.this.agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(TimeLengthBatchView.this.factory);
                TimeLengthBatchView.this.sendBatch(true);
                TimeLengthBatchView.this.agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(this.agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long scheduled = this.timePeriodProvide.deltaAdd(currentTime, null, true, this.agentInstanceContext) - delta;
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(scheduled, this.handle, this.scheduleSlot);
        this.callbackScheduledTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime() + scheduled;
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.handle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.lastBatch, true, this.factory.getViewName(), null);
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.factory.getViewName(), null);
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

