/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timelengthbatch;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.view.core.DataWindowBatchingViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.timelengthbatch.TimeLengthBatchViewFactory;
import com.espertech.esper.common.internal.view.util.TimeBatchFlags;
import com.espertech.esper.common.internal.view.util.ViewFactoryTimePeriodHelper;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.List;

public class TimeLengthBatchViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious,
ScheduleHandleCallbackProvider,
DataWindowBatchingViewForge {
    protected ExprForge sizeForge;
    protected boolean isForceUpdate;
    protected boolean isStartEager;
    protected TimePeriodComputeForge timePeriodCompute;
    protected int scheduleCallbackId;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        ExprNode[] validated = ViewForgeSupport.validate(this.getViewName(), parameters, viewForgeEnv, streamNumber);
        String errorMessage = this.getViewName() + " view requires a numeric or time period parameter as a time interval size, and an integer parameter as a maximal number-of-events, and an optional list of control keywords as a string parameter (please see the documentation)";
        if (validated.length != 2 && validated.length != 3) {
            throw new ViewParameterException(errorMessage);
        }
        this.timePeriodCompute = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), parameters.get(0), errorMessage, 0, viewForgeEnv, streamNumber);
        this.sizeForge = ViewForgeSupport.validateSizeParam(this.getViewName(), validated[1], 1);
        if (validated.length > 2) {
            Object keywords = ViewForgeSupport.evaluate(validated[2].getForge().getExprEvaluator(), 2, this.getViewName());
            TimeBatchFlags flags = TimeBatchFlags.processKeywords(keywords, errorMessage);
            this.isForceUpdate = flags.isForceUpdate();
            this.isStartEager = flags.isStartEager();
        }
    }

    @Override
    public void attach(EventType parentEventType, int streamNumber, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    @Override
    protected Class typeOfFactory() {
        return TimeLengthBatchViewFactory.class;
    }

    @Override
    protected String factoryMethod() {
        return "timelengthbatch";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("No schedule callback id");
        }
        method.getBlock().declareVar(TimePeriodCompute.class, "eval", this.timePeriodCompute.makeEvaluator(method, classScope)).exprDotMethod(factory, "setSize", ExprNodeUtilityCodegen.codegenEvaluator(this.sizeForge, method, this.getClass(), classScope)).exprDotMethod(factory, "setTimePeriodCompute", CodegenExpressionBuilder.ref("eval")).exprDotMethod(factory, "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId)).exprDotMethod(factory, "setForceUpdate", CodegenExpressionBuilder.constant(this.isForceUpdate)).exprDotMethod(factory, "setStartEager", CodegenExpressionBuilder.constant(this.isStartEager));
    }

    @Override
    public String getViewName() {
        return "Time-Length-Batch";
    }
}

