/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timetolive;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.previous.IStreamSortRankRandomAccess;
import com.espertech.esper.common.internal.view.sort.SortWindowIterator;
import com.espertech.esper.common.internal.view.timetolive.TimeOrderViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class TimeOrderView
extends ViewSupport
implements DataWindowView,
AgentInstanceStopCallback {
    private final AgentInstanceContext agentInstanceContext;
    private final TimeOrderViewFactory factory;
    private final IStreamSortRankRandomAccess optionalSortedRandomAccess;
    private final EPStatementHandleCallbackSchedule handle;
    private final long scheduleSlot;
    private final TimePeriodProvide timePeriodProvide;
    private EventBean[] eventsPerStream = new EventBean[1];
    private TreeMap<Object, Object> sortedEvents;
    private boolean isCallbackScheduled;
    private int eventCount;

    public TimeOrderView(final AgentInstanceViewFactoryChainContext agentInstanceContext, final TimeOrderViewFactory factory, IStreamSortRankRandomAccess optionalSortedRandomAccess, TimePeriodProvide timePeriodProvide) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.factory = factory;
        this.optionalSortedRandomAccess = optionalSortedRandomAccess;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timePeriodProvide = timePeriodProvide;
        this.sortedEvents = new TreeMap();
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext.getAgentInstanceContext(), ScheduleObjectType.view, factory.getViewName());
                agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(factory);
                TimeOrderView.this.expire();
                agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        EventBean[] postOldEventsArray = null;
        if (oldData != null) {
            for (int i = 0; i < oldData.length; ++i) {
                EventBean oldDataItem = oldData[i];
                Long sortValues = this.getTimestamp(oldDataItem);
                boolean result = CollectionUtil.removeEventByKeyLazyListMap(sortValues, oldDataItem, this.sortedEvents);
                if (!result) continue;
                --this.eventCount;
                postOldEventsArray = postOldEventsArray == null ? oldData : CollectionUtil.addArrayWithSetSemantics(postOldEventsArray, oldData);
            }
        }
        if (newData != null && newData.length > 0) {
            long runtimeTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            long windowTailTime = runtimeTime - this.timePeriodProvide.deltaAdd(runtimeTime, null, true, this.agentInstanceContext) + 1L;
            long oldestEvent = Long.MAX_VALUE;
            if (!this.sortedEvents.isEmpty()) {
                oldestEvent = (Long)this.sortedEvents.firstKey();
            }
            boolean addedOlderEvent = false;
            ArrayList<EventBean> postOldEvents = null;
            for (int i = 0; i < newData.length; ++i) {
                EventBean newEvent = newData[i];
                Long timestamp = this.getTimestamp(newEvent);
                if (timestamp < windowTailTime) {
                    if (postOldEvents == null) {
                        postOldEvents = new ArrayList<EventBean>(2);
                    }
                    postOldEvents.add(newEvent);
                    continue;
                }
                if (timestamp < oldestEvent) {
                    addedOlderEvent = true;
                    oldestEvent = timestamp;
                }
                CollectionUtil.addEventByKeyLazyListMapBack(timestamp, newEvent, this.sortedEvents);
                ++this.eventCount;
            }
            if (!this.sortedEvents.isEmpty()) {
                if (!this.isCallbackScheduled) {
                    long callbackWait = oldestEvent - windowTailTime + 1L;
                    this.agentInstanceContext.getAuditProvider().scheduleAdd(callbackWait, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                    this.agentInstanceContext.getStatementContext().getSchedulingService().add(callbackWait, this.handle, this.scheduleSlot);
                    this.isCallbackScheduled = true;
                } else if (addedOlderEvent) {
                    oldestEvent = (Long)this.sortedEvents.firstKey();
                    long callbackWait = oldestEvent - windowTailTime + 1L;
                    this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                    this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                    this.agentInstanceContext.getAuditProvider().scheduleAdd(callbackWait, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                    this.agentInstanceContext.getStatementContext().getSchedulingService().add(callbackWait, this.handle, this.scheduleSlot);
                    this.isCallbackScheduled = true;
                }
            }
            if (postOldEvents != null) {
                postOldEventsArray = postOldEvents.toArray(new EventBean[postOldEvents.size()]);
            }
            if (this.optionalSortedRandomAccess != null) {
                this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.eventCount);
            }
        }
        if (this.child != null) {
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, postOldEventsArray);
            this.child.update(newData, postOldEventsArray);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    protected Long getTimestamp(EventBean newEvent) {
        this.eventsPerStream[0] = newEvent;
        return (Long)this.factory.timestampEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
    }

    public boolean isEmpty() {
        return this.sortedEvents.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SortWindowIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName();
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.sortedEvents, false, this.factory.getViewName(), this.eventCount, null);
    }

    protected final void expire() {
        Long oldestKey;
        long currentTime = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
        long expireBeforeTimestamp = currentTime - this.timePeriodProvide.deltaSubtract(currentTime, null, true, this.agentInstanceContext) + 1L;
        this.isCallbackScheduled = false;
        ArrayList<EventBean> releaseEvents = null;
        while (true) {
            if (this.sortedEvents.isEmpty()) {
                oldestKey = null;
                break;
            }
            oldestKey = (Long)this.sortedEvents.firstKey();
            if (oldestKey >= expireBeforeTimestamp) break;
            Object released = this.sortedEvents.remove(oldestKey);
            if (released == null) continue;
            if (released instanceof List) {
                List releasedEventList = (List)released;
                if (releaseEvents == null) {
                    releaseEvents = releasedEventList;
                } else {
                    releaseEvents.addAll(releasedEventList);
                }
                this.eventCount -= releasedEventList.size();
                continue;
            }
            EventBean releasedEvent = (EventBean)released;
            if (releaseEvents == null) {
                releaseEvents = new ArrayList<EventBean>(4);
            }
            releaseEvents.add(releasedEvent);
            --this.eventCount;
        }
        if (this.optionalSortedRandomAccess != null) {
            this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.eventCount);
        }
        if (this.child != null && releaseEvents != null && !releaseEvents.isEmpty()) {
            EventBean[] oldEvents = releaseEvents.toArray(new EventBean[releaseEvents.size()]);
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldEvents);
            this.child.update(null, oldEvents);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        if (oldestKey == null) {
            return;
        }
        long callbackWait = oldestKey - expireBeforeTimestamp + 1L;
        this.agentInstanceContext.getAuditProvider().scheduleAdd(callbackWait, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
        this.agentInstanceContext.getStatementContext().getSchedulingService().add(callbackWait, this.handle, this.scheduleSlot);
        this.isCallbackScheduled = true;
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.handle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    public ViewFactory getFactory() {
        return this.factory;
    }
}

