/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.union;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.collection.RefCountedSet;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewDataVisitableContainer;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewDataVisitorContained;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.intersect.IntersectDefaultView;
import com.espertech.esper.common.internal.view.intersect.LastPostObserver;
import com.espertech.esper.common.internal.view.intersect.LastPostObserverView;
import com.espertech.esper.common.internal.view.union.UnionViewFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class UnionView
extends ViewSupport
implements LastPostObserver,
AgentInstanceStopCallback,
DataWindowView,
ViewDataVisitableContainer {
    protected final AgentInstanceContext agentInstanceContext;
    private final UnionViewFactory unionViewFactory;
    protected final View[] views;
    private final EventBean[][] oldEventsPerView;
    protected final RefCountedSet<EventBean> unionWindow;
    private final List<EventBean> removalEvents = new ArrayList<EventBean>();
    private boolean isHasRemovestreamData;
    private boolean isRetainObserverEvents;
    private boolean isDiscardObserverEvents;

    public UnionView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext, UnionViewFactory factory, List<View> viewList) {
        int i;
        this.agentInstanceContext = agentInstanceViewFactoryContext.getAgentInstanceContext();
        this.unionViewFactory = factory;
        this.views = viewList.toArray(new View[viewList.size()]);
        this.unionWindow = new RefCountedSet();
        this.oldEventsPerView = new EventBean[viewList.size()][];
        for (i = 0; i < viewList.size(); ++i) {
            LastPostObserverView view = new LastPostObserverView(i);
            this.views[i].setChild(view);
            view.setObserver(this);
        }
        for (i = 0; i < this.views.length; ++i) {
            for (EventBean theEvent : this.views[i]) {
                this.unionWindow.add(theEvent);
            }
        }
    }

    public View[] getViewContained() {
        return this.views;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.unionViewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.unionViewFactory, newData, oldData);
        OneEventCollection oldDataColl = null;
        if (oldData != null) {
            this.isDiscardObserverEvents = true;
            try {
                for (View view : this.views) {
                    this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.unionViewFactory, null, oldData);
                    view.update(null, oldData);
                    this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
                }
            }
            finally {
                this.isDiscardObserverEvents = false;
            }
            for (EventBean eventBean : oldData) {
                this.unionWindow.removeAll(eventBean);
            }
            oldDataColl = new OneEventCollection();
            oldDataColl.add(oldData);
        }
        if (newData != null) {
            for (EventBean eventBean : newData) {
                this.unionWindow.add(eventBean, this.views.length);
            }
            this.isHasRemovestreamData = false;
            this.isRetainObserverEvents = true;
            try {
                for (View view : this.views) {
                    this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.unionViewFactory, newData, null);
                    view.update(newData, null);
                    this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
                }
            }
            finally {
                this.isRetainObserverEvents = false;
            }
            if (this.isHasRemovestreamData) {
                List<EventBean> removedEvents = null;
                for (int i = 0; i < this.oldEventsPerView.length; ++i) {
                    if (this.oldEventsPerView[i] == null) continue;
                    EventBean[] viewOldData = this.oldEventsPerView[i];
                    this.oldEventsPerView[i] = null;
                    for (EventBean old : viewOldData) {
                        boolean isNoMoreRef = this.unionWindow.remove(old);
                        if (!isNoMoreRef) continue;
                        if (removedEvents == null) {
                            this.removalEvents.clear();
                            removedEvents = this.removalEvents;
                        }
                        removedEvents.add(old);
                    }
                }
                if (removedEvents != null) {
                    if (oldDataColl == null) {
                        oldDataColl = new OneEventCollection();
                    }
                    for (EventBean oldItem : removedEvents) {
                        oldDataColl.add(oldItem);
                    }
                }
            }
        }
        if (this.child != null) {
            EventBean[] oldEvents = oldDataColl != null ? oldDataColl.toArray() : null;
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.unionViewFactory, newData, oldEvents);
            this.child.update(newData, oldEvents);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public EventType getEventType() {
        return this.unionViewFactory.getEventType();
    }

    @Override
    public Iterator<EventBean> iterator() {
        return this.unionWindow.keyIterator();
    }

    @Override
    public void newData(int streamId, EventBean[] newEvents, EventBean[] oldEvents) {
        if (oldEvents == null || this.isDiscardObserverEvents) {
            return;
        }
        if (this.isRetainObserverEvents) {
            this.oldEventsPerView[streamId] = oldEvents;
            this.isHasRemovestreamData = true;
            return;
        }
        List<EventBean> removedEvents = null;
        for (EventBean old : oldEvents) {
            boolean isNoMoreRef = this.unionWindow.remove(old);
            if (!isNoMoreRef) continue;
            if (removedEvents == null) {
                this.removalEvents.clear();
                removedEvents = this.removalEvents;
            }
            removedEvents.add(old);
        }
        if (removedEvents != null) {
            EventBean[] removed = removedEvents.toArray(new EventBean[removedEvents.size()]);
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.unionViewFactory, null, removed);
            this.child.update(null, removed);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        for (View view : this.views) {
            if (!(view instanceof AgentInstanceStopCallback)) continue;
            ((AgentInstanceStopCallback)((Object)view)).stop(services);
        }
    }

    @Override
    public void visitViewContainer(ViewDataVisitorContained viewDataVisitor) {
        IntersectDefaultView.visitViewContained(viewDataVisitor, this.unionViewFactory, this.views);
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        throw new UnsupportedOperationException("Must visit container");
    }

    public UnionViewFactory getViewFactory() {
        return this.unionViewFactory;
    }
}

