/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.util;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.internal.collection.ArrayEventIterator;
import com.espertech.esper.common.internal.collection.SingleEventIterator;
import com.espertech.esper.common.internal.event.core.EventBeanUtility;
import java.util.ArrayDeque;
import java.util.Iterator;

public class EventDistinctIterator
implements Iterator<EventBean> {
    private static final Iterator<EventBean> NULL_ITER = new SingleEventIterator(null);
    private final Iterator<EventBean> sourceIterator;
    private final EventPropertyValueGetter distinctKeyGetter;
    private Iterator<EventBean> resultIterator;

    public EventDistinctIterator(Iterator<EventBean> sourceIterator, EventPropertyValueGetter distinctKeyGetter) {
        this.sourceIterator = sourceIterator;
        this.distinctKeyGetter = distinctKeyGetter;
    }

    @Override
    public EventBean next() {
        if (this.resultIterator == null) {
            this.initialize();
        }
        return this.resultIterator.next();
    }

    @Override
    public boolean hasNext() {
        if (this.resultIterator == null) {
            this.initialize();
        }
        return this.resultIterator.hasNext();
    }

    private void initialize() {
        if (this.sourceIterator == null || !this.sourceIterator.hasNext()) {
            this.resultIterator = NULL_ITER;
            return;
        }
        EventBean eventFirst = this.sourceIterator.next();
        if (!this.sourceIterator.hasNext()) {
            this.resultIterator = new SingleEventIterator(eventFirst);
            return;
        }
        ArrayDeque<EventBean> events = new ArrayDeque<EventBean>();
        events.add(eventFirst);
        while (this.sourceIterator.hasNext()) {
            events.add(this.sourceIterator.next());
        }
        EventBean[] unique = EventBeanUtility.getDistinctByProp(events, this.distinctKeyGetter);
        this.resultIterator = new ArrayEventIterator(unique);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

